/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.calculated;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.caching.MetaContexts;
import me.lucko.luckperms.api.metastacking.MetaStackDefinition;
import me.lucko.luckperms.api.metastacking.MetaStackElement;
import me.lucko.luckperms.common.caching.AbstractCachedData;
import me.lucko.luckperms.common.caching.type.MetaAccumulator;
import me.lucko.luckperms.common.calculators.CalculatorFactory;
import me.lucko.luckperms.common.calculators.PermissionCalculator;
import me.lucko.luckperms.common.calculators.PermissionCalculatorMetadata;
import me.lucko.luckperms.common.metastacking.SimpleMetaStackDefinition;
import me.lucko.luckperms.common.metastacking.StandardStackElements;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.processors.MapProcessor;
import me.lucko.luckperms.common.processors.PermissionProcessor;
import me.lucko.luckperms.common.processors.WildcardProcessor;
import me.lucko.luckperms.sponge.processors.FixedDefaultsProcessor;
import me.lucko.luckperms.sponge.processors.SpongeWildcardProcessor;
import me.lucko.luckperms.sponge.service.calculated.CalculatedSubject;

public class SubjectCachedData
extends AbstractCachedData
implements CalculatorFactory {
    private static final MetaStackDefinition DEFAULT_META_STACK = new SimpleMetaStackDefinition((List<MetaStackElement>)ImmutableList.of((Object)StandardStackElements.HIGHEST), "", "", "");
    private final CalculatedSubject subject;

    SubjectCachedData(CalculatedSubject subject, LuckPermsPlugin plugin) {
        super(plugin);
        this.subject = subject;
    }

    @Override
    protected PermissionCalculatorMetadata getMetadataForContexts(Contexts contexts) {
        return PermissionCalculatorMetadata.of(null, this.subject.getParentCollection().getIdentifier() + "/" + this.subject.getIdentifier(), contexts.getContexts());
    }

    @Override
    protected CalculatorFactory getCalculatorFactory() {
        return this;
    }

    @Override
    protected MetaContexts getDefaultMetaContexts(Contexts contexts) {
        return MetaContexts.of(contexts, DEFAULT_META_STACK, DEFAULT_META_STACK);
    }

    @Override
    protected Map<String, Boolean> resolvePermissions() {
        return this.subject.resolveAllPermissions();
    }

    @Override
    protected Map<String, Boolean> resolvePermissions(Contexts contexts) {
        return this.subject.resolveAllPermissions(contexts.getContexts().makeImmutable());
    }

    @Override
    protected void resolveMeta(MetaAccumulator accumulator) {
        this.subject.resolveAllOptions(accumulator);
    }

    @Override
    protected void resolveMeta(MetaAccumulator accumulator, MetaContexts contexts) {
        this.subject.resolveAllOptions(accumulator, contexts.getContexts().getContexts().makeImmutable());
    }

    @Override
    public PermissionCalculator build(Contexts contexts, PermissionCalculatorMetadata metadata) {
        ImmutableList.Builder processors = ImmutableList.builder();
        processors.add((Object)new MapProcessor());
        processors.add((Object)new SpongeWildcardProcessor());
        processors.add((Object)new WildcardProcessor());
        if (!this.subject.getParentCollection().isDefaultsCollection()) {
            processors.add((Object)new FixedDefaultsProcessor(this.subject.getService(), contexts.getContexts().makeImmutable(), this.subject.getDefaults()));
        }
        return new PermissionCalculator(this.plugin, metadata, (ImmutableList<PermissionProcessor>)processors.build());
    }
}

