/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.calculators;

import com.google.common.collect.ImmutableList;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.common.calculators.CalculatorFactory;
import me.lucko.luckperms.common.calculators.PermissionCalculator;
import me.lucko.luckperms.common.calculators.PermissionCalculatorMetadata;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.processors.MapProcessor;
import me.lucko.luckperms.common.processors.PermissionProcessor;
import me.lucko.luckperms.common.processors.RegexProcessor;
import me.lucko.luckperms.common.processors.WildcardProcessor;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import me.lucko.luckperms.sponge.processors.GroupDefaultsProcessor;
import me.lucko.luckperms.sponge.processors.SpongeWildcardProcessor;
import me.lucko.luckperms.sponge.processors.UserDefaultsProcessor;

public class SpongeCalculatorFactory
implements CalculatorFactory {
    private final LPSpongePlugin plugin;

    public SpongeCalculatorFactory(LPSpongePlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public PermissionCalculator build(Contexts contexts, PermissionCalculatorMetadata metadata) {
        ImmutableList.Builder processors = ImmutableList.builder();
        processors.add((Object)new MapProcessor());
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLYING_REGEX).booleanValue()) {
            processors.add((Object)new RegexProcessor());
        }
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLYING_WILDCARDS).booleanValue()) {
            processors.add((Object)new WildcardProcessor());
        }
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLY_SPONGE_IMPLICIT_WILDCARDS).booleanValue()) {
            processors.add((Object)new SpongeWildcardProcessor());
        }
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLY_SPONGE_DEFAULT_SUBJECTS).booleanValue()) {
            if (metadata.getHolderType().isUser()) {
                processors.add((Object)new UserDefaultsProcessor(this.plugin.getService(), contexts.getContexts().makeImmutable()));
            } else if (metadata.getHolderType().isGroup()) {
                processors.add((Object)new GroupDefaultsProcessor(this.plugin.getService(), contexts.getContexts().makeImmutable()));
            }
        }
        return new PermissionCalculator(this.plugin, metadata, (ImmutableList<PermissionProcessor>)processors.build());
    }
}

