/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose;

import com.google.gson.JsonObject;
import java.util.Map;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.utils.StackTracePrinter;
import me.lucko.luckperms.common.utils.gson.JArray;
import me.lucko.luckperms.common.utils.gson.JObject;
import me.lucko.luckperms.common.verbose.CheckOrigin;

public class CheckData {
    private final CheckOrigin checkOrigin;
    private final String checkTarget;
    private final ImmutableContextSet checkContext;
    private final StackTraceElement[] checkTrace;
    private final String permission;
    private final Tristate result;

    public CheckData(CheckOrigin checkOrigin, String checkTarget, ImmutableContextSet checkContext, StackTraceElement[] checkTrace, String permission, Tristate result) {
        this.checkOrigin = checkOrigin;
        this.checkTarget = checkTarget;
        this.checkContext = checkContext;
        this.checkTrace = checkTrace;
        this.permission = permission;
        this.result = result;
    }

    public CheckOrigin getCheckOrigin() {
        return this.checkOrigin;
    }

    public String getCheckTarget() {
        return this.checkTarget;
    }

    public ImmutableContextSet getCheckContext() {
        return this.checkContext;
    }

    public StackTraceElement[] getCheckTrace() {
        return this.checkTrace;
    }

    public String getPermission() {
        return this.permission;
    }

    public Tristate getResult() {
        return this.result;
    }

    private JObject formBaseJson() {
        return new JObject().add("who", new JObject().add("identifier", this.checkTarget)).add("permission", this.permission).add("result", this.result.name().toLowerCase()).add("origin", this.checkOrigin.name().toLowerCase()).add("context", new JArray().consume(arr -> {
            for (Map.Entry<String, String> contextPair : this.checkContext.toSet()) {
                arr.add(new JObject().add("key", contextPair.getKey()).add("value", contextPair.getValue()));
            }
        }));
    }

    public JsonObject toJson() {
        return this.formBaseJson().toJson();
    }

    public JsonObject toJson(StackTracePrinter tracePrinter) {
        return this.formBaseJson().add("trace", new JArray().consume(arr -> {
            int overflow = tracePrinter.process(this.checkTrace, StackTracePrinter.elementToString(arr::add));
            if (overflow != 0) {
                arr.add("... and " + overflow + " more");
            }
        })).toJson();
    }
}

