/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import me.lucko.luckperms.common.utils.ImmutableCollectors;

public class Paginated<T> {
    private final List<T> content;

    public Paginated(Collection<T> content) {
        this.content = ImmutableList.copyOf(content);
    }

    public Paginated(Stream<T> content) {
        this.content = (List)content.collect(ImmutableCollectors.toList());
    }

    public List<T> getContent() {
        return this.content;
    }

    public int getMaxPages(int entriesPerPage) {
        return (int)Math.ceil((double)this.content.size() / (double)entriesPerPage);
    }

    public SortedMap<Integer, T> getPage(int pageNo, int entries) {
        if (pageNo < 1) {
            throw new IllegalArgumentException("pageNo cannot be less than 1: " + pageNo);
        }
        int minimumEntries = pageNo * entries - entries + 1;
        if (this.content.size() < minimumEntries) {
            throw new IllegalStateException("Content does not contain that many elements. Requested: " + minimumEntries + ", Size: " + this.content.size());
        }
        TreeMap<Integer, T> out = new TreeMap<Integer, T>();
        int max = minimumEntries + entries - 1;
        int index = 0;
        for (T e : this.content) {
            if (++index >= minimumEntries) {
                out.put(index, e);
            }
            if (index != max) continue;
            break;
        }
        return out;
    }
}

