/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.hikari;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.HikariConnectionFactory;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.lib.hikari.HikariConfig;

public class MariaDbConnectionFactory
extends HikariConnectionFactory {
    public MariaDbConnectionFactory(StorageCredentials configuration) {
        super(configuration);
    }

    @Override
    public String getImplementationName() {
        return "MariaDB";
    }

    @Override
    protected String getDriverClass() {
        return "me.lucko.luckperms.lib.mariadb.MariaDbDataSource";
    }

    @Override
    protected void appendProperties(HikariConfig config, StorageCredentials credentials) {
        Set<Map.Entry<String, String>> properties = credentials.getProperties().entrySet();
        if (properties.isEmpty()) {
            return;
        }
        String propertiesString = properties.stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(";"));
        config.addDataSourceProperty("properties", (Object)propertiesString);
    }

    @Override
    public Function<String, String> getStatementProcessor() {
        return s -> s.replace("'", "`");
    }
}

