/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.primarygroup;

import java.util.Optional;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.inheritance.InheritanceGraph;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.primarygroup.ContextualHolder;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AllParentsByWeightHolder
extends ContextualHolder {
    public AllParentsByWeightHolder(User user) {
        super(user);
    }

    @Override
    protected @NonNull Optional<String> calculateValue(Contexts contexts) {
        InheritanceGraph graph = this.user.getPlugin().getInheritanceHandler().getGraph(contexts);
        Iterable<User> traversal = graph.traverse(this.user.getPlugin().getConfiguration().get(ConfigKeys.INHERITANCE_TRAVERSAL_ALGORITHM), this.user);
        Group bestGroup = null;
        int best = 0;
        for (PermissionHolder permissionHolder : traversal) {
            if (!(permissionHolder instanceof Group)) continue;
            Group g = (Group)permissionHolder;
            int weight = g.getWeight().orElse(0);
            if (bestGroup != null && g.getWeight().orElse(0) <= best) continue;
            bestGroup = g;
            best = weight;
        }
        return bestGroup == null ? Optional.empty() : Optional.of(bestGroup.getName());
    }
}

