/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.event.gen;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import me.lucko.luckperms.api.LuckPermsApi;
import me.lucko.luckperms.api.event.LuckPermsEvent;
import me.lucko.luckperms.api.event.Param;
import me.lucko.luckperms.common.utils.ImmutableCollectors;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;

public class GeneratedEventSpec {
    private static final Method TO_STRING_METHOD;
    private static final Method EQUALS_METHOD;
    private static final Method HASHCODE_METHOD;
    private static final Method GET_API_METHOD;
    private static final LoadingCache<Class<? extends LuckPermsEvent>, GeneratedEventSpec> CACHE;
    private final Class<? extends LuckPermsEvent> eventClass;
    private final List<Method> methods;
    private final List<Class<?>> returnTypes;

    public static GeneratedEventSpec lookup(Class<? extends LuckPermsEvent> event) {
        return (GeneratedEventSpec)CACHE.get(event);
    }

    private GeneratedEventSpec(Class<? extends LuckPermsEvent> eventClass) {
        this.eventClass = eventClass;
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : eventClass.getMethods()) {
            if (method.isDefault() || GET_API_METHOD.equals(method)) continue;
            methods.add(method);
        }
        methods.sort(Comparator.comparingInt(o -> o.isAnnotationPresent(Param.class) ? o.getAnnotation(Param.class).value() : 0));
        this.methods = ImmutableList.copyOf(methods);
        this.returnTypes = (List)this.methods.stream().map(Method::getReturnType).collect(ImmutableCollectors.toList());
    }

    public LuckPermsEvent newInstance(LuckPermsApi api, Object ... params) {
        if (params.length != this.methods.size()) {
            throw new IllegalStateException("param length differs from number of methods. expected " + this.methods.size() + " - " + this.methods);
        }
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            Class<?> expectedType = this.returnTypes.get(i);
            if (expectedType.isInstance(param)) continue;
            throw new IllegalArgumentException("Parameter at index " + i + " cannot be assigned to " + expectedType);
        }
        EventInvocationHandler eventInvocationHandler = new EventInvocationHandler(api, params);
        return (LuckPermsEvent)Proxy.newProxyInstance(GeneratedEventSpec.class.getClassLoader(), new Class[]{this.eventClass}, (InvocationHandler)eventInvocationHandler);
    }

    static {
        try {
            TO_STRING_METHOD = Object.class.getMethod("toString", new Class[0]);
            EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
            HASHCODE_METHOD = Object.class.getMethod("hashCode", new Class[0]);
            GET_API_METHOD = LuckPermsEvent.class.getMethod("getApi", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        CACHE = Caffeine.newBuilder().build(GeneratedEventSpec::new);
    }

    private final class EventInvocationHandler
    implements InvocationHandler {
        private final LuckPermsApi api;
        private final Object[] fields;

        EventInvocationHandler(LuckPermsApi api, Object[] fields) {
            this.api = api;
            this.fields = fields;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (TO_STRING_METHOD.equals(method)) {
                return "GeneratedEvent(proxy=" + proxy.getClass().getName() + "@" + Integer.toHexString(proxy.hashCode()) + ", class=" + GeneratedEventSpec.this.eventClass.getName() + ", fields=" + Arrays.toString(this.fields) + ")";
            }
            if (EQUALS_METHOD.equals(method)) {
                return proxy == args[0];
            }
            if (HASHCODE_METHOD.equals(method)) {
                return System.identityHashCode(proxy);
            }
            if (GET_API_METHOD.equals(method)) {
                return this.api;
            }
            if (method.getDeclaringClass() == Object.class || method.isDefault()) {
                return MethodHandles.lookup().in(method.getDeclaringClass()).unreflectSpecial(method, method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
            }
            int methodIndex = GeneratedEventSpec.this.methods.indexOf(method);
            if (methodIndex == -1) {
                throw new UnsupportedOperationException("Method not supported: " + method);
            }
            return this.fields[methodIndex];
        }
    }
}

