/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.PlayerSaveResult;
import me.lucko.luckperms.api.caching.GroupData;
import me.lucko.luckperms.api.caching.UserData;
import me.lucko.luckperms.api.event.Cancellable;
import me.lucko.luckperms.api.event.LuckPermsEvent;
import me.lucko.luckperms.api.event.cause.CreationCause;
import me.lucko.luckperms.api.event.cause.DeletionCause;
import me.lucko.luckperms.api.event.group.GroupCacheLoadEvent;
import me.lucko.luckperms.api.event.group.GroupCreateEvent;
import me.lucko.luckperms.api.event.group.GroupDataRecalculateEvent;
import me.lucko.luckperms.api.event.group.GroupDeleteEvent;
import me.lucko.luckperms.api.event.group.GroupLoadAllEvent;
import me.lucko.luckperms.api.event.group.GroupLoadEvent;
import me.lucko.luckperms.api.event.log.LogBroadcastEvent;
import me.lucko.luckperms.api.event.log.LogNetworkPublishEvent;
import me.lucko.luckperms.api.event.log.LogNotifyEvent;
import me.lucko.luckperms.api.event.log.LogPublishEvent;
import me.lucko.luckperms.api.event.log.LogReceiveEvent;
import me.lucko.luckperms.api.event.node.NodeAddEvent;
import me.lucko.luckperms.api.event.node.NodeClearEvent;
import me.lucko.luckperms.api.event.node.NodeRemoveEvent;
import me.lucko.luckperms.api.event.player.PlayerDataSaveEvent;
import me.lucko.luckperms.api.event.source.Source;
import me.lucko.luckperms.api.event.sync.ConfigReloadEvent;
import me.lucko.luckperms.api.event.sync.PostSyncEvent;
import me.lucko.luckperms.api.event.sync.PreNetworkSyncEvent;
import me.lucko.luckperms.api.event.sync.PreSyncEvent;
import me.lucko.luckperms.api.event.track.TrackCreateEvent;
import me.lucko.luckperms.api.event.track.TrackDeleteEvent;
import me.lucko.luckperms.api.event.track.TrackLoadAllEvent;
import me.lucko.luckperms.api.event.track.TrackLoadEvent;
import me.lucko.luckperms.api.event.track.mutate.TrackAddGroupEvent;
import me.lucko.luckperms.api.event.track.mutate.TrackClearEvent;
import me.lucko.luckperms.api.event.track.mutate.TrackRemoveGroupEvent;
import me.lucko.luckperms.api.event.user.UserCacheLoadEvent;
import me.lucko.luckperms.api.event.user.UserDataRecalculateEvent;
import me.lucko.luckperms.api.event.user.UserFirstLoginEvent;
import me.lucko.luckperms.api.event.user.UserLoadEvent;
import me.lucko.luckperms.api.event.user.UserLoginProcessEvent;
import me.lucko.luckperms.api.event.user.track.UserDemoteEvent;
import me.lucko.luckperms.api.event.user.track.UserPromoteEvent;
import me.lucko.luckperms.common.api.delegates.model.ApiPermissionHolder;
import me.lucko.luckperms.common.api.delegates.model.ApiUser;
import me.lucko.luckperms.common.event.AbstractEventBus;
import me.lucko.luckperms.common.event.gen.GeneratedEventSpec;
import me.lucko.luckperms.common.event.model.EntitySourceImpl;
import me.lucko.luckperms.common.event.model.SenderEntity;
import me.lucko.luckperms.common.event.model.UnknownSource;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.sender.Sender;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EventFactory {
    private final AbstractEventBus<?> eventBus;

    public EventFactory(AbstractEventBus<?> eventBus) {
        this.eventBus = eventBus;
    }

    public AbstractEventBus getEventBus() {
        return this.eventBus;
    }

    private boolean shouldPost(Class<? extends LuckPermsEvent> eventClass) {
        return this.eventBus.shouldPost(eventClass);
    }

    private void post(LuckPermsEvent event) {
        this.eventBus.post(event);
    }

    private <T extends LuckPermsEvent> void post(Class<T> eventClass, Supplier<T> supplier) {
        if (Cancellable.class.isAssignableFrom(eventClass)) {
            throw new RuntimeException("Cancellable event cannot be posted async (" + eventClass + ")");
        }
        this.eventBus.getPlugin().getBootstrap().getScheduler().executeAsync(() -> {
            if (!this.shouldPost(eventClass)) {
                return;
            }
            LuckPermsEvent event = (LuckPermsEvent)supplier.get();
            this.eventBus.post(event);
        });
    }

    private <T extends LuckPermsEvent> T generate(Class<T> eventClass, Object ... params) {
        return (T)GeneratedEventSpec.lookup(eventClass).newInstance(this.eventBus.getApiProvider(), params);
    }

    public void handleGroupCacheLoad(Group group, GroupData data) {
        this.post(GroupCacheLoadEvent.class, () -> this.generate(GroupCacheLoadEvent.class, group.getApiDelegate(), data));
    }

    public void handleGroupCreate(Group group, CreationCause cause) {
        this.post(GroupCreateEvent.class, () -> this.generate(GroupCreateEvent.class, new Object[]{group.getApiDelegate(), cause}));
    }

    public void handleGroupDelete(Group group, DeletionCause cause) {
        this.post(GroupDeleteEvent.class, () -> this.generate(GroupDeleteEvent.class, new Object[]{group.getName(), ImmutableSet.copyOf((Collection)group.enduringData().immutable().values()), cause}));
    }

    public void handleGroupLoadAll() {
        this.post(GroupLoadAllEvent.class, () -> this.generate(GroupLoadAllEvent.class, new Object[0]));
    }

    public void handleGroupLoad(Group group) {
        this.post(GroupLoadEvent.class, () -> this.generate(GroupLoadEvent.class, group.getApiDelegate()));
    }

    public boolean handleLogBroadcast(boolean initialState, LogEntry entry, LogBroadcastEvent.Origin origin) {
        if (!this.shouldPost(LogBroadcastEvent.class)) {
            return initialState;
        }
        AtomicBoolean cancel = new AtomicBoolean(initialState);
        this.post(this.generate(LogBroadcastEvent.class, new Object[]{cancel, entry, origin}));
        return cancel.get();
    }

    public boolean handleLogPublish(boolean initialState, LogEntry entry) {
        if (!this.shouldPost(LogPublishEvent.class)) {
            return initialState;
        }
        AtomicBoolean cancel = new AtomicBoolean(initialState);
        this.post(this.generate(LogPublishEvent.class, cancel, entry));
        return cancel.get();
    }

    public boolean handleLogNetworkPublish(boolean initialState, UUID id, LogEntry entry) {
        if (!this.shouldPost(LogNetworkPublishEvent.class)) {
            return initialState;
        }
        AtomicBoolean cancel = new AtomicBoolean(initialState);
        this.post(this.generate(LogNetworkPublishEvent.class, cancel, id, entry));
        return cancel.get();
    }

    public boolean handleLogNotify(boolean initialState, LogEntry entry, LogNotifyEvent.Origin origin, Sender sender) {
        if (!this.shouldPost(LogNotifyEvent.class)) {
            return initialState;
        }
        AtomicBoolean cancel = new AtomicBoolean(initialState);
        this.post(this.generate(LogNotifyEvent.class, new Object[]{cancel, entry, origin, new SenderEntity(sender)}));
        return cancel.get();
    }

    public void handleLogReceive(UUID id, LogEntry entry) {
        this.post(LogReceiveEvent.class, () -> this.generate(LogReceiveEvent.class, id, entry));
    }

    public void handleNodeAdd(Node node, PermissionHolder target, Collection<? extends Node> before, Collection<? extends Node> after) {
        this.post(NodeAddEvent.class, () -> this.generate(NodeAddEvent.class, EventFactory.getDelegate(target), ImmutableSet.copyOf((Collection)before), ImmutableSet.copyOf((Collection)after), node));
    }

    public void handleNodeClear(PermissionHolder target, Collection<? extends Node> before, Collection<? extends Node> after) {
        this.post(NodeClearEvent.class, () -> this.generate(NodeClearEvent.class, EventFactory.getDelegate(target), ImmutableSet.copyOf((Collection)before), ImmutableSet.copyOf((Collection)after)));
    }

    public void handleNodeRemove(Node node, PermissionHolder target, Collection<? extends Node> before, Collection<? extends Node> after) {
        this.post(NodeRemoveEvent.class, () -> this.generate(NodeRemoveEvent.class, EventFactory.getDelegate(target), ImmutableSet.copyOf((Collection)before), ImmutableSet.copyOf((Collection)after), node));
    }

    public void handleConfigReload() {
        this.post(ConfigReloadEvent.class, () -> this.generate(ConfigReloadEvent.class, new Object[0]));
    }

    public void handlePostSync() {
        this.post(PostSyncEvent.class, () -> this.generate(PostSyncEvent.class, new Object[0]));
    }

    public boolean handleNetworkPreSync(boolean initialState, UUID id) {
        if (!this.shouldPost(PreNetworkSyncEvent.class)) {
            return initialState;
        }
        AtomicBoolean cancel = new AtomicBoolean(initialState);
        this.post(this.generate(PreNetworkSyncEvent.class, cancel, id));
        return cancel.get();
    }

    public boolean handlePreSync(boolean initialState) {
        if (!this.shouldPost(PreSyncEvent.class)) {
            return initialState;
        }
        AtomicBoolean cancel = new AtomicBoolean(initialState);
        this.post(this.generate(PreSyncEvent.class, cancel));
        return cancel.get();
    }

    public void handleTrackCreate(Track track, CreationCause cause) {
        this.post(TrackCreateEvent.class, () -> this.generate(TrackCreateEvent.class, new Object[]{track.getApiDelegate(), cause}));
    }

    public void handleTrackDelete(Track track, DeletionCause cause) {
        this.post(TrackDeleteEvent.class, () -> this.generate(TrackDeleteEvent.class, new Object[]{track.getName(), ImmutableList.copyOf(track.getGroups()), cause}));
    }

    public void handleTrackLoadAll() {
        this.post(TrackLoadAllEvent.class, () -> this.generate(TrackLoadAllEvent.class, new Object[0]));
    }

    public void handleTrackLoad(Track track) {
        this.post(TrackLoadEvent.class, () -> this.generate(TrackLoadEvent.class, track.getApiDelegate()));
    }

    public void handleTrackAddGroup(Track track, String group, List<String> before, List<String> after) {
        this.post(TrackAddGroupEvent.class, () -> this.generate(TrackAddGroupEvent.class, track.getApiDelegate(), ImmutableList.copyOf((Collection)before), ImmutableList.copyOf((Collection)after), group));
    }

    public void handleTrackClear(Track track, List<String> before) {
        this.post(TrackClearEvent.class, () -> this.generate(TrackClearEvent.class, track.getApiDelegate(), ImmutableList.copyOf((Collection)before), ImmutableList.of()));
    }

    public void handleTrackRemoveGroup(Track track, String group, List<String> before, List<String> after) {
        this.post(TrackRemoveGroupEvent.class, () -> this.generate(TrackRemoveGroupEvent.class, track.getApiDelegate(), ImmutableList.copyOf((Collection)before), ImmutableList.copyOf((Collection)after), group));
    }

    public void handleUserCacheLoad(User user, UserData data) {
        this.post(UserCacheLoadEvent.class, () -> this.generate(UserCacheLoadEvent.class, new ApiUser(user), data));
    }

    public void handleDataRecalculate(PermissionHolder holder) {
        if (holder.getType().isUser()) {
            User user = (User)holder;
            this.post(UserDataRecalculateEvent.class, () -> this.generate(UserDataRecalculateEvent.class, user.getApiDelegate(), user.getCachedData()));
        } else {
            Group group = (Group)holder;
            this.post(GroupDataRecalculateEvent.class, () -> this.generate(GroupDataRecalculateEvent.class, group.getApiDelegate(), group.getCachedData()));
        }
    }

    public void handleUserFirstLogin(UUID uuid, String username) {
        this.post(UserFirstLoginEvent.class, () -> this.generate(UserFirstLoginEvent.class, uuid, username));
    }

    public void handlePlayerDataSave(UUID uuid, String username, PlayerSaveResult result) {
        this.post(PlayerDataSaveEvent.class, () -> this.generate(PlayerDataSaveEvent.class, uuid, username, result));
    }

    public void handleUserLoad(User user) {
        this.post(UserLoadEvent.class, () -> this.generate(UserLoadEvent.class, new ApiUser(user)));
    }

    public void handleUserLoginProcess(UUID uuid, String username, User user) {
        this.post(UserLoginProcessEvent.class, () -> this.generate(UserLoginProcessEvent.class, uuid, username, new ApiUser(user)));
    }

    public void handleUserDemote(User user, Track track, String from, String to, @Nullable Sender source) {
        this.post(UserDemoteEvent.class, () -> {
            Source s = source == null ? UnknownSource.INSTANCE : new EntitySourceImpl(new SenderEntity(source));
            return this.generate(UserDemoteEvent.class, s, track.getApiDelegate(), new ApiUser(user), Optional.ofNullable(from), Optional.ofNullable(to));
        });
    }

    public void handleUserPromote(User user, Track track, String from, String to, @Nullable Sender source) {
        this.post(UserPromoteEvent.class, () -> {
            Source s = source == null ? UnknownSource.INSTANCE : new EntitySourceImpl(new SenderEntity(source));
            return this.generate(UserPromoteEvent.class, s, track.getApiDelegate(), new ApiUser(user), Optional.ofNullable(from), Optional.ofNullable(to));
        });
    }

    private static ApiPermissionHolder getDelegate(PermissionHolder holder) {
        if (holder instanceof Group) {
            return ((Group)holder).getApiDelegate();
        }
        if (holder instanceof User) {
            return new ApiUser((User)holder);
        }
        throw new AssertionError();
    }
}

