/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.dependencies.relocation;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class Relocation {
    private static final String RELOCATION_PREFIX = "me.lucko.luckperms.lib.";
    private final String pattern;
    private final String relocatedPattern;

    public static Relocation of(String id, String pattern) {
        return new Relocation(pattern.replace("{}", "."), RELOCATION_PREFIX + id);
    }

    public static List<Relocation> allOf(Relocation ... relocations) {
        return Arrays.asList(relocations);
    }

    private Relocation(String pattern, String relocatedPattern) {
        this.pattern = pattern;
        this.relocatedPattern = relocatedPattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getRelocatedPattern() {
        return this.relocatedPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relocation that = (Relocation)o;
        return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.relocatedPattern, that.relocatedPattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.relocatedPattern);
    }
}

