/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.track;

import java.util.List;
import me.lucko.luckperms.api.event.cause.CreationCause;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.utils.Predicates;

public class TrackClone
extends SubCommand<Track> {
    public TrackClone(LocaleManager locale) {
        super(CommandSpec.TRACK_CLONE.localize(locale), "clone", CommandPermission.TRACK_CLONE, Predicates.not(1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Track track, List<String> args, String label) {
        String newTrackName = args.get(0).toLowerCase();
        if (!DataConstraints.TRACK_NAME_TEST.test(newTrackName)) {
            Message.TRACK_INVALID_ENTRY.send(sender, newTrackName);
            return CommandResult.INVALID_ARGS;
        }
        Track newTrack = plugin.getStorage().createAndLoadTrack(newTrackName, CreationCause.INTERNAL).join();
        if (newTrack == null) {
            Message.TRACK_LOAD_ERROR.send(sender, new Object[0]);
            return CommandResult.LOADING_ERROR;
        }
        newTrack.setGroups(track.getGroups());
        Message.CLONE_SUCCESS.send(sender, track.getName(), newTrack.getName());
        ExtendedLogEntry.build().actor(sender).acted(track).action("clone", newTrack.getName()).build().submit(plugin, sender);
        StorageAssistant.save(newTrack, sender, plugin);
        return CommandResult.SUCCESS;
    }
}

