/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.DurationFormatter;
import me.lucko.luckperms.common.utils.Predicates;

public class GroupInfo
extends SubCommand<Group> {
    public GroupInfo(LocaleManager locale) {
        super(CommandSpec.GROUP_INFO.localize(locale), "info", CommandPermission.GROUP_INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Group group, List<String> args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), group)) {
            Message.COMMAND_NO_PERMISSION.send(sender, new Object[0]);
            return CommandResult.NO_PERMISSION;
        }
        Message.GROUP_INFO_GENERAL.send(sender, group.getName(), group.getPlainDisplayName(), group.getWeight().isPresent() ? Integer.valueOf(group.getWeight().getAsInt()) : "None");
        Set parents = group.enduringData().asSet().stream().filter(Node::isGroupNode).filter(Node::isPermanent).collect(Collectors.toSet());
        Set tempParents = group.enduringData().asSet().stream().filter(Node::isGroupNode).filter(Node::isTemporary).collect(Collectors.toSet());
        if (!parents.isEmpty()) {
            Message.INFO_PARENT_HEADER.send(sender, new Object[0]);
            for (Node node : parents) {
                Message.INFO_PARENT_ENTRY.send(sender, node.getGroupName(), MessageUtils.getAppendableNodeContextString(plugin.getLocaleManager(), node));
            }
        }
        if (!tempParents.isEmpty()) {
            Message.INFO_TEMP_PARENT_HEADER.send(sender, new Object[0]);
            for (Node node : tempParents) {
                Message.INFO_PARENT_ENTRY.send(sender, node.getGroupName(), MessageUtils.getAppendableNodeContextString(plugin.getLocaleManager(), node));
                Message.INFO_PARENT_ENTRY_EXPIRY.send(sender, DurationFormatter.LONG.formatDateDiff(node.getExpiryUnixTime()));
            }
        }
        return CommandResult.SUCCESS;
    }
}

