/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.backup;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.CommandManager;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.sender.DummySender;
import me.lucko.luckperms.common.sender.Sender;

public class Importer
implements Runnable {
    private final CommandManager commandManager;
    private final Set<Sender> notify;
    private final List<String> commandList;
    private final List<ImportCommand> commands;

    public Importer(CommandManager commandManager, Sender executor, List<String> commands) {
        this.commandManager = commandManager;
        this.notify = executor.isConsole() ? ImmutableSet.of((Object)executor) : ImmutableSet.of((Object)executor, (Object)commandManager.getPlugin().getConsoleSender());
        this.commandList = commands.stream().map(String::trim).filter(s -> !s.isEmpty()).filter(s -> !s.startsWith("#")).filter(s -> !s.startsWith("//")).map(s -> s.startsWith("/luckperms ") ? s.substring("/luckperms ".length()) : s).map(s -> s.startsWith("/lp ") ? s.substring("/lp ".length()) : s).collect(Collectors.toList());
        this.commands = new ArrayList<ImportCommand>();
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        this.notify.forEach(s -> Message.IMPORT_START.send((Sender)s, new Object[0]));
        CompletableFuture<Void> updateTask = CompletableFuture.runAsync(() -> {
            Void cfr_ignored_0 = (Void)this.commandManager.getPlugin().getSyncTaskBuffer().requestDirectly();
        });
        this.notify.forEach(s -> Message.IMPORT_INFO.send((Sender)s, "Processing commands..."));
        int index = 1;
        for (String string : this.commandList) {
            ImportCommand cmd = new ImportCommand(this.commandManager, index, string);
            this.commands.add(cmd);
            if (cmd.getCommand().startsWith("creategroup ") || cmd.getCommand().startsWith("createtrack ")) {
                cmd.process();
            }
            ++index;
        }
        ListMultimap sections = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        for (ImportCommand cmd : this.commands) {
            sections.put((Object)Strings.nullToEmpty((String)cmd.getTarget()), (Object)cmd);
        }
        this.notify.forEach(s -> Message.IMPORT_INFO.send((Sender)s, "Waiting for initial update task to complete..."));
        updateTask.join();
        this.notify.forEach(s -> Message.IMPORT_INFO.send((Sender)s, "Setting up command executor..."));
        ExecutorService executorService = Executors.newFixedThreadPool(128, new ThreadFactoryBuilder().setNameFormat("luckperms-importer-%d").build());
        HashSet<CompletionStage> futures = new HashSet<CompletionStage>();
        AtomicInteger processedCount = new AtomicInteger(0);
        for (Collection subList : sections.asMap().values()) {
            futures.add(CompletableFuture.completedFuture(subList).thenAcceptAsync(sl -> {
                for (ImportCommand cmd : sl) {
                    cmd.process();
                    processedCount.incrementAndGet();
                }
            }, (Executor)executorService));
        }
        CompletableFuture<Void> overallFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        this.notify.forEach(s -> Message.IMPORT_INFO.send((Sender)s, "All commands have been processed and scheduled - now waiting for the execution to complete."));
        while (true) {
            try {
                overallFuture.get(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                this.sendProgress(processedCount.get());
                continue;
            }
            break;
        }
        executorService.shutdown();
        long endTime = System.currentTimeMillis();
        double seconds = (endTime - startTime) / 1000L;
        int errors = (int)this.commands.stream().filter(v -> v.getResult().wasFailure()).count();
        switch (errors) {
            case 0: {
                this.notify.forEach(s -> Message.IMPORT_END_COMPLETE.send((Sender)s, seconds));
                break;
            }
            case 1: {
                this.notify.forEach(s -> Message.IMPORT_END_COMPLETE_ERR_SIN.send((Sender)s, seconds, errors));
                break;
            }
            default: {
                this.notify.forEach(s -> Message.IMPORT_END_COMPLETE_ERR.send((Sender)s, seconds, errors));
            }
        }
        AtomicInteger errIndex = new AtomicInteger(1);
        for (ImportCommand e : this.commands) {
            if (e.getResult() == null || !e.getResult().wasFailure()) continue;
            this.notify.forEach(s -> {
                Message.IMPORT_END_ERROR_HEADER.send((Sender)s, errIndex.get(), e.getId(), e.getCommand(), e.getResult().toString());
                for (String out : e.getOutput()) {
                    Message.IMPORT_END_ERROR_CONTENT.send((Sender)s, out);
                }
                Message.IMPORT_END_ERROR_FOOTER.send((Sender)s, new Object[0]);
            });
            errIndex.incrementAndGet();
        }
    }

    private void sendProgress(int processedCount) {
        int percent = processedCount * 100 / this.commandList.size();
        int errors = (int)this.commands.stream().filter(v -> v.isCompleted() && v.getResult().wasFailure()).count();
        if (errors == 1) {
            this.notify.forEach(s -> Message.IMPORT_PROGRESS_SIN.send((Sender)s, percent, processedCount, this.commands.size(), errors));
        } else {
            this.notify.forEach(s -> Message.IMPORT_PROGRESS.send((Sender)s, percent, processedCount, this.commands.size(), errors));
        }
    }

    private static class ImportCommand
    extends DummySender {
        private static final Splitter ARGUMENT_SPLITTER = Splitter.on((Pattern)CommandManager.COMMAND_SEPARATOR_PATTERN).omitEmptyStrings();
        private static final Splitter SPACE_SPLITTER = Splitter.on((String)" ");
        private final CommandManager commandManager;
        private final int id;
        private final String command;
        private final String target;
        private boolean completed = false;
        private final List<String> output = new ArrayList<String>();
        private CommandResult result = CommandResult.FAILURE;

        ImportCommand(CommandManager commandManager, int id, String command) {
            super(commandManager.getPlugin());
            this.commandManager = commandManager;
            this.id = id;
            this.command = command;
            this.target = ImportCommand.determineTarget(command);
        }

        @Override
        protected void consumeMessage(String s) {
            this.output.add(s);
        }

        public void process() {
            if (this.isCompleted()) {
                return;
            }
            try {
                List<String> args = CommandManager.stripQuotes(ARGUMENT_SPLITTER.splitToList((CharSequence)this.getCommand()));
                CommandResult result = this.commandManager.onCommand(this, "lp", args, Runnable::run).get();
                this.setResult(result);
            }
            catch (Exception e) {
                this.setResult(CommandResult.FAILURE);
                e.printStackTrace();
            }
            this.setCompleted(true);
        }

        private static String determineTarget(String command) {
            if (command.startsWith("user ") && command.length() > "user ".length()) {
                String subCmd = command.substring("user ".length());
                if (!subCmd.contains(" ")) {
                    return null;
                }
                String targetUser = (String)SPACE_SPLITTER.split((CharSequence)subCmd).iterator().next();
                return "u:" + targetUser;
            }
            if (command.startsWith("group ") && command.length() > "group ".length()) {
                String subCmd = command.substring("group ".length());
                if (!subCmd.contains(" ")) {
                    return null;
                }
                String targetGroup = (String)SPACE_SPLITTER.split((CharSequence)subCmd).iterator().next();
                return "g:" + targetGroup;
            }
            if (command.startsWith("track ") && command.length() > "track ".length()) {
                String subCmd = command.substring("track ".length());
                if (!subCmd.contains(" ")) {
                    return null;
                }
                String targetTrack = (String)SPACE_SPLITTER.split((CharSequence)subCmd).iterator().next();
                return "t:" + targetTrack;
            }
            if (command.startsWith("creategroup ") && command.length() > "creategroup ".length()) {
                String targetGroup = command.substring("creategroup ".length());
                return "g:" + targetGroup;
            }
            if (command.startsWith("createtrack ") && command.length() > "createtrack ".length()) {
                String targetTrack = command.substring("createtrack ".length());
                return "t:" + targetTrack;
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public String getCommand() {
            return this.command;
        }

        public String getTarget() {
            return this.target;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public List<String> getOutput() {
            return this.output;
        }

        public CommandResult getResult() {
            return this.result;
        }

        public void setCompleted(boolean completed) {
            this.completed = completed;
        }

        public void setResult(CommandResult result) {
            this.result = result;
        }
    }
}

