/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.delegates.manager;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.api.HeldPermission;
import me.lucko.luckperms.api.event.cause.CreationCause;
import me.lucko.luckperms.api.event.cause.DeletionCause;
import me.lucko.luckperms.common.api.ApiUtils;
import me.lucko.luckperms.common.api.delegates.manager.ApiAbstractManager;
import me.lucko.luckperms.common.api.delegates.model.ApiGroup;
import me.lucko.luckperms.common.bulkupdate.comparisons.Constraint;
import me.lucko.luckperms.common.bulkupdate.comparisons.StandardComparison;
import me.lucko.luckperms.common.managers.group.GroupManager;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.utils.ImmutableCollectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiGroupManager
extends ApiAbstractManager<Group, me.lucko.luckperms.api.Group, GroupManager<?>>
implements me.lucko.luckperms.api.manager.GroupManager {
    public ApiGroupManager(LuckPermsPlugin plugin, GroupManager<?> handle) {
        super(plugin, handle);
    }

    @Override
    protected me.lucko.luckperms.api.Group getDelegateFor(Group internal) {
        if (internal == null) {
            return null;
        }
        return internal.getApiDelegate();
    }

    @Override
    public @NonNull CompletableFuture<me.lucko.luckperms.api.Group> createAndLoadGroup(@NonNull String name) {
        name = ApiUtils.checkName(Objects.requireNonNull(name, "name"));
        return this.plugin.getStorage().createAndLoadGroup(name, CreationCause.API).thenApply(this::getDelegateFor);
    }

    @Override
    public @NonNull CompletableFuture<Optional<me.lucko.luckperms.api.Group>> loadGroup(@NonNull String name) {
        name = ApiUtils.checkName(Objects.requireNonNull(name, "name"));
        return this.plugin.getStorage().loadGroup(name).thenApply(opt -> opt.map(this::getDelegateFor));
    }

    @Override
    public @NonNull CompletableFuture<Void> saveGroup(@NonNull me.lucko.luckperms.api.Group group) {
        Objects.requireNonNull(group, "group");
        return this.plugin.getStorage().saveGroup(ApiGroup.cast(group));
    }

    @Override
    public @NonNull CompletableFuture<Void> deleteGroup(@NonNull me.lucko.luckperms.api.Group group) {
        Objects.requireNonNull(group, "group");
        if (group.getName().equalsIgnoreCase("default")) {
            throw new IllegalArgumentException("Cannot delete the default group.");
        }
        return this.plugin.getStorage().deleteGroup(ApiGroup.cast(group), DeletionCause.API);
    }

    @Override
    public @NonNull CompletableFuture<Void> loadAllGroups() {
        return this.plugin.getStorage().loadAllGroups();
    }

    @Override
    public @NonNull CompletableFuture<List<HeldPermission<String>>> getWithPermission(@NonNull String permission) {
        Objects.requireNonNull(permission, "permission");
        return this.plugin.getStorage().getGroupsWithPermission(Constraint.of(StandardComparison.EQUAL, permission));
    }

    @Override
    public me.lucko.luckperms.api.Group getGroup(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return this.getDelegateFor((Group)((GroupManager)this.handle).getIfLoaded(name));
    }

    @Override
    public @NonNull Set<me.lucko.luckperms.api.Group> getLoadedGroups() {
        return (Set)((GroupManager)this.handle).getAll().values().stream().map(this::getDelegateFor).collect(ImmutableCollectors.toSet());
    }

    @Override
    public boolean isLoaded(@NonNull String name) {
        Objects.requireNonNull(name, "name");
        return ((GroupManager)this.handle).isLoaded(name);
    }
}

