/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api;

import java.util.Objects;
import java.util.Optional;
import me.lucko.luckperms.api.DemotionResult;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DemotionResults {
    public static DemotionResult success(String groupFrom, String groupTo) {
        return new Impl(DemotionResult.Status.SUCCESS, groupFrom, groupTo);
    }

    public static DemotionResult removedFromFirst(String groupFrom) {
        return new Impl(DemotionResult.Status.REMOVED_FROM_FIRST_GROUP, groupFrom, null);
    }

    public static DemotionResult malformedTrack(String groupTo) {
        return new Impl(DemotionResult.Status.MALFORMED_TRACK, null, groupTo);
    }

    public static DemotionResult notOnTrack() {
        return new Impl(DemotionResult.Status.NOT_ON_TRACK);
    }

    public static DemotionResult ambiguousCall() {
        return new Impl(DemotionResult.Status.AMBIGUOUS_CALL);
    }

    public static DemotionResult undefinedFailure() {
        return new Impl(DemotionResult.Status.UNDEFINED_FAILURE);
    }

    private DemotionResults() {
    }

    private static final class Impl
    implements DemotionResult {
        private final DemotionResult.Status status;
        private final String groupFrom;
        private final String groupTo;

        private Impl(DemotionResult.Status status, String groupFrom, String groupTo) {
            this.status = status;
            this.groupFrom = groupFrom;
            this.groupTo = groupTo;
        }

        private Impl(DemotionResult.Status status) {
            this(status, null, null);
        }

        @Override
        public @NonNull DemotionResult.Status getStatus() {
            return this.status;
        }

        @Override
        public @NonNull Optional<String> getGroupFrom() {
            return Optional.ofNullable(this.groupFrom);
        }

        @Override
        public @NonNull Optional<String> getGroupTo() {
            return Optional.ofNullable(this.groupTo);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Impl that = (Impl)o;
            return this.status == that.status && Objects.equals(this.groupFrom, that.groupFrom) && Objects.equals(this.groupTo, that.groupTo);
        }

        public int hashCode() {
            return Objects.hash(this.status, this.groupFrom, this.groupTo);
        }

        public String toString() {
            return "DemotionResult(status=" + this.status + ", groupFrom='" + this.groupFrom + "', groupTo='" + this.groupTo + "')";
        }
    }
}

