/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.portal.features;

import com.flowpowered.math.vector.Vector3i;
import com.gmail.trentech.pjp.Main;
import com.gmail.trentech.pjp.data.DataQueries;
import com.gmail.trentech.pjp.effects.Particle;
import com.gmail.trentech.pjp.effects.ParticleColor;
import com.gmail.trentech.pjp.effects.Particles;
import com.gmail.trentech.pjp.portal.features.Coordinate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class Properties
implements DataSerializable {
    private List<Location<World>> frame = new ArrayList<Location<World>>();
    private List<Location<World>> fill = new ArrayList<Location<World>>();
    private Particle particle;
    private Optional<ParticleColor> color;

    public Properties(Particle particle, Optional<ParticleColor> color) {
        this.particle = particle;
        this.color = color;
    }

    public Properties(List<Location<World>> frame, List<Location<World>> fill, Particle particle, Optional<ParticleColor> color) {
        this.frame = frame;
        this.fill = fill;
        this.particle = particle;
        this.color = color;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public void setParticle(Particle particle) {
        this.particle = particle;
    }

    public Optional<ParticleColor> getParticleColor() {
        return this.color;
    }

    public void setParticleColor(Optional<ParticleColor> color) {
        this.color = color;
    }

    public List<Location<World>> getFrame() {
        return this.frame;
    }

    public void addFrame(Location<World> location) {
        this.frame.add(location);
    }

    public void removeFrame(Location<World> location) {
        this.frame.remove(location);
    }

    public List<Location<World>> getFill() {
        return this.fill;
    }

    public void addFill(Location<World> location) {
        this.fill.add(location);
    }

    public void removeFill(Location<World> location) {
        this.fill.remove(location);
    }

    private void updateClient(Player player, boolean reset) {
        BlockState state = this.getBlock();
        Sponge.getScheduler().createTaskBuilder().delayTicks(5L).execute(c -> {
            for (Location<World> location : this.getFill()) {
                Optional optionalChunk = ((World)location.getExtent()).getChunk(location.getChunkPosition());
                if (!optionalChunk.isPresent() || !((Chunk)optionalChunk.get()).isLoaded()) continue;
                if (reset) {
                    player.resetBlockChange(location.getBlockPosition());
                    continue;
                }
                player.sendBlockChange(location.getBlockPosition(), state);
            }
        }).submit((Object)Main.getPlugin());
    }

    public void update(boolean reset) {
        World world = (World)this.getFrame().get(0).getExtent();
        Predicate<Entity> filter = e -> e.getType().equals(EntityTypes.PLAYER);
        for (Entity entity : world.getEntities(filter)) {
            this.updateClient((Player)entity, reset);
        }
    }

    private BlockState getBlock() {
        BlockState blockState = (BlockState)BlockTypes.PORTAL.getDefaultState().with(Keys.AXIS, (Object)Axis.Z).get();
        ArrayList<Vector3i> frameV = new ArrayList<Vector3i>();
        for (Location<World> location : this.getFrame()) {
            frameV.add(location.getBlockPosition());
        }
        for (Location<World> location : this.getFill()) {
            Location east = location.getRelative(Direction.EAST);
            Location west = location.getRelative(Direction.WEST);
            Location north = location.getRelative(Direction.NORTH);
            Location south = location.getRelative(Direction.SOUTH);
            Location up = location.getRelative(Direction.UP);
            Location down = location.getRelative(Direction.DOWN);
            if (frameV.contains(east.getBlockPosition()) && frameV.contains(up.getBlockPosition()) && !frameV.contains(north.getBlockPosition()) && !frameV.contains(south.getBlockPosition())) {
                blockState = (BlockState)BlockTypes.PORTAL.getDefaultState().with(Keys.AXIS, (Object)Axis.X).get();
                break;
            }
            if (frameV.contains(west.getBlockPosition()) && frameV.contains(up.getBlockPosition()) && !frameV.contains(north.getBlockPosition()) && !frameV.contains(south.getBlockPosition())) {
                blockState = (BlockState)BlockTypes.PORTAL.getDefaultState().with(Keys.AXIS, (Object)Axis.X).get();
                break;
            }
            if (frameV.contains(east.getBlockPosition()) && frameV.contains(down.getBlockPosition()) && !frameV.contains(north.getBlockPosition()) && !frameV.contains(south.getBlockPosition())) {
                blockState = (BlockState)BlockTypes.PORTAL.getDefaultState().with(Keys.AXIS, (Object)Axis.X).get();
                break;
            }
            if (frameV.contains(west.getBlockPosition()) && frameV.contains(down.getBlockPosition()) && !frameV.contains(north.getBlockPosition()) && !frameV.contains(south.getBlockPosition())) {
                blockState = (BlockState)BlockTypes.PORTAL.getDefaultState().with(Keys.AXIS, (Object)Axis.X).get();
                break;
            }
            if (frameV.contains(north.getBlockPosition()) && frameV.contains(up.getBlockPosition()) && !frameV.contains(east.getBlockPosition()) && !frameV.contains(west.getBlockPosition())) {
                blockState = (BlockState)BlockTypes.PORTAL.getDefaultState().with(Keys.AXIS, (Object)Axis.Z).get();
                break;
            }
            if (frameV.contains(south.getBlockPosition()) && frameV.contains(up.getBlockPosition()) && !frameV.contains(east.getBlockPosition()) && !frameV.contains(west.getBlockPosition())) {
                blockState = (BlockState)BlockTypes.PORTAL.getDefaultState().with(Keys.AXIS, (Object)Axis.Z).get();
                break;
            }
            if (frameV.contains(north.getBlockPosition()) && frameV.contains(down.getBlockPosition()) && !frameV.contains(east.getBlockPosition()) && !frameV.contains(west.getBlockPosition())) {
                blockState = (BlockState)BlockTypes.PORTAL.getDefaultState().with(Keys.AXIS, (Object)Axis.Z).get();
                break;
            }
            if (frameV.contains(south.getBlockPosition()) && frameV.contains(down.getBlockPosition()) && !frameV.contains(east.getBlockPosition()) && !frameV.contains(west.getBlockPosition())) {
                blockState = (BlockState)BlockTypes.PORTAL.getDefaultState().with(Keys.AXIS, (Object)Axis.Z).get();
                break;
            }
            if (frameV.contains(east.getBlockPosition()) && frameV.contains(north.getBlockPosition()) && !frameV.contains(up.getBlockPosition()) && !frameV.contains(down.getBlockPosition())) {
                blockState = BlockTypes.END_PORTAL.getDefaultState();
                break;
            }
            if (frameV.contains(west.getBlockPosition()) && frameV.contains(north.getBlockPosition()) && !frameV.contains(up.getBlockPosition()) && !frameV.contains(down.getBlockPosition())) {
                blockState = BlockTypes.END_PORTAL.getDefaultState();
                break;
            }
            if (frameV.contains(east.getBlockPosition()) && frameV.contains(south.getBlockPosition()) && !frameV.contains(up.getBlockPosition()) && !frameV.contains(down.getBlockPosition())) {
                blockState = BlockTypes.END_PORTAL.getDefaultState();
                break;
            }
            if (!frameV.contains(west.getBlockPosition()) || !frameV.contains(south.getBlockPosition()) || frameV.contains(up.getBlockPosition()) || frameV.contains(down.getBlockPosition())) continue;
            blockState = BlockTypes.END_PORTAL.getDefaultState();
            break;
        }
        return blockState;
    }

    public int getContentVersion() {
        return 0;
    }

    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(DataQueries.PARTICLE, (Object)this.particle.getName());
        if (this.color.isPresent()) {
            container.set(DataQueries.COLOR, (Object)this.color.get().getName());
        }
        ArrayList<String> frame = new ArrayList<String>();
        for (Location<World> location : this.frame) {
            frame.add(Coordinate.serialize(location));
        }
        container.set(DataQueries.FRAME, frame);
        ArrayList<String> fill = new ArrayList<String>();
        for (Location<World> location : this.fill) {
            fill.add(Coordinate.serialize(location));
        }
        container.set(DataQueries.FILL, fill);
        return container;
    }

    public static class Builder
    extends AbstractDataBuilder<Properties> {
        public Builder() {
            super(Properties.class, 0);
        }

        protected Optional<Properties> buildContent(DataView container) throws InvalidDataException {
            if (container.contains(DataQueries.FRAME, new DataQuery[]{DataQueries.FILL, DataQueries.PARTICLE})) {
                Particle particle = Particles.get((String)container.getString(DataQueries.PARTICLE).get()).get();
                Optional<ParticleColor> color = Optional.empty();
                ArrayList<Location<World>> frame = new ArrayList<Location<World>>();
                ArrayList<Location<World>> fill = new ArrayList<Location<World>>();
                if (container.contains(DataQueries.COLOR)) {
                    color = ParticleColor.get((String)container.getString(DataQueries.COLOR).get());
                }
                for (String loc : (List)container.getStringList(DataQueries.FRAME).get()) {
                    frame.add(Coordinate.deserialize(loc).get());
                }
                for (String loc : (List)container.getStringList(DataQueries.FILL).get()) {
                    fill.add(Coordinate.deserialize(loc).get());
                }
                return Optional.of(new Properties(frame, fill, particle, color));
            }
            return Optional.empty();
        }
    }
}

