/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.portal;

import com.gmail.trentech.pjp.effects.Particle;
import com.gmail.trentech.pjp.effects.ParticleColor;
import com.gmail.trentech.pjp.effects.Particles;
import com.gmail.trentech.pjp.events.ConstructPortalEvent;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.PortalService;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class LegacyBuilder {
    private boolean fill = false;
    private Portal portal;

    public LegacyBuilder(Portal portal) {
        if (portal.getProperties().isPresent()) {
            this.portal = portal;
        }
    }

    public Portal getPortal() {
        return this.portal;
    }

    public LegacyBuilder addFrame(Location<World> location) {
        this.portal.getProperties().get().addFrame(location);
        return this;
    }

    public LegacyBuilder removeFrame(Location<World> location) {
        this.portal.getProperties().get().removeFrame(location);
        return this;
    }

    public LegacyBuilder addFill(Location<World> location) {
        this.portal.getProperties().get().addFill(location);
        return this;
    }

    public LegacyBuilder removeFill(Location<World> location) {
        this.portal.getProperties().get().removeFill(location);
        return this;
    }

    public boolean isFill() {
        return this.fill;
    }

    public LegacyBuilder setFill(boolean fill) {
        this.fill = fill;
        return this;
    }

    public boolean build(Player player) {
        if (this.portal.getProperties().get().getFill().isEmpty()) {
            return false;
        }
        if (!Sponge.getEventManager().post((Event)new ConstructPortalEvent(this.portal.getProperties().get().getFrame(), this.portal.getProperties().get().getFill(), Cause.builder().append((Object)this.portal).build(EventContext.builder().add(EventContextKeys.CREATOR, (Object)player).build())))) {
            BlockState block = BlockTypes.AIR.getDefaultState();
            Particle particle = Particles.getDefaultEffect("creation");
            Optional<ParticleColor> color = Particles.getDefaultColor("creation", particle.isColorable());
            for (Location<World> location : this.portal.getProperties().get().getFill()) {
                if (!((World)location.getExtent()).setBlock(location.getBlockX(), location.getBlockY(), location.getBlockZ(), block)) {
                    return false;
                }
                particle.spawnParticle(location, false, color);
            }
            ((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).create(this.portal, this.portal.getName());
            return true;
        }
        return false;
    }
}

