/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.listeners;

import com.gmail.trentech.pjc.core.ConfigManager;
import com.gmail.trentech.pjc.core.TeleportManager;
import com.gmail.trentech.pjp.Main;
import com.gmail.trentech.pjp.commands.CMDBack;
import com.gmail.trentech.pjp.data.Keys;
import com.gmail.trentech.pjp.data.mutable.BedData;
import com.gmail.trentech.pjp.data.mutable.LastLocationData;
import com.gmail.trentech.pjp.effects.Particle;
import com.gmail.trentech.pjp.effects.Particles;
import com.gmail.trentech.pjp.events.TeleportEvent;
import com.gmail.trentech.pjp.portal.features.Coordinate;
import com.gmail.trentech.pjp.utils.Timings;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class TeleportListener {
    private Timings timings;

    public TeleportListener(Timings timings) {
        this.timings = timings;
    }

    @Listener
    public void onInteractBLockEvent(InteractBlockEvent.Secondary event, @Root Player player) {
        if (event.getTargetBlock().getState().getType().equals(BlockTypes.BED)) {
            HashMap<String, Coordinate> list = new HashMap<String, Coordinate>();
            Optional optionalList = player.get(Keys.BED_LOCATIONS);
            if (optionalList.isPresent()) {
                list = (Map)optionalList.get();
            }
            list.put(player.getWorld().getUniqueId().toString(), new Coordinate((Location<World>)player.getLocation()));
            player.offer((ValueContainer)new BedData(list));
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Respawn location Saved."}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onTeleportEvent(TeleportEvent event) {
        this.timings.onTeleportEvent().startTimingIfSync();
        try {
            Player player = event.getPlayer();
            Optional<String> optionalPermission = event.getPermission();
            if (optionalPermission.isPresent() && !player.hasPermission(optionalPermission.get())) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "Requires permission ", TextColors.YELLOW, optionalPermission.get()}));
                event.setCancelled(true);
                return;
            }
            Location src = player.getLocation();
            double price = event.getPrice();
            Optional optionalEconomy = Sponge.getServiceManager().provide(EconomyService.class);
            if (price != 0.0 && optionalEconomy.isPresent()) {
                EconomyService economy = (EconomyService)optionalEconomy.get();
                UniqueAccount account = (UniqueAccount)economy.getOrCreateAccount(player.getUniqueId()).get();
                if (account.withdraw(economy.getDefaultCurrency(), new BigDecimal(price), Cause.of((EventContext)EventContext.builder().add(EventContextKeys.PLAYER, (Object)player).build(), (Object)player)).getResult() != ResultType.SUCCESS) {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "Not enough money. You need $", new DecimalFormat("#,###,##0.00").format(price)}));
                    event.setCancelled(true);
                    return;
                }
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "Charged $", new DecimalFormat("#,###,##0.00").format(price)}));
            }
            Particle particle = Particles.getDefaultEffect("teleport");
            particle.spawnParticle((Location<World>)src, true, Particles.getDefaultColor("teleport", particle.isColorable()));
            particle.spawnParticle((Location<World>)src.getRelative(Direction.UP), true, Particles.getDefaultColor("teleport", particle.isColorable()));
        }
        finally {
            this.timings.onTeleportEvent().stopTimingIfSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onTeleportEventLocal(TeleportEvent.Local event) {
        this.timings.onTeleportEventLocal().startTimingIfSync();
        try {
            Player player = event.getPlayer();
            Location src = event.getSource();
            src = ((World)src.getExtent()).getLocation(src.getBlockX(), src.getBlockY(), src.getBlockZ());
            Location<World> dest = event.getDestination();
            Optional optionalLocation = Optional.empty();
            if (event.force()) {
                optionalLocation = Optional.of(dest);
            } else {
                optionalLocation = TeleportManager.getSafeLocation(dest);
                if (!optionalLocation.isPresent()) {
                    player.sendMessage(Text.of((Object[])new Object[]{Text.builder().color(TextColors.RED).append(new Text[]{Text.of((String)"Unsafe spawn point detected. ")}).onClick((ClickAction)TextActions.executeCallback((Consumer)TeleportManager.setUnsafeLocation(dest))).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, TextStyles.UNDERLINE, "Click Here"})}).build(), TextColors.RED, " or use the -f flag on portal to force teleport."}));
                    event.setCancelled(true);
                    return;
                }
            }
            event.setDestination((Location<World>)((Location)optionalLocation.get()));
            CommentedConfigurationNode node = ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options", "teleport_message"});
            if (node.getNode(new Object[]{"enable"}).getBoolean()) {
                Text title = TextSerializers.FORMATTING_CODE.deserialize(node.getNode(new Object[]{"title"}).getString().replaceAll("%WORLD%", ((World)dest.getExtent()).getName()).replaceAll("\\%X%", Integer.toString(dest.getBlockX())).replaceAll("\\%Y%", Integer.toString(dest.getBlockY())).replaceAll("\\%Z%", Integer.toString(dest.getBlockZ())));
                Text subTitle = TextSerializers.FORMATTING_CODE.deserialize(node.getNode(new Object[]{"sub_title"}).getString().replaceAll("%WORLD%", ((World)dest.getExtent()).getName()).replaceAll("\\%X%", Integer.toString(dest.getBlockX())).replaceAll("\\%Y%", Integer.toString(dest.getBlockY())).replaceAll("\\%Z%", Integer.toString(dest.getBlockZ())));
                player.sendTitle(Title.of((Text)title, (Text)subTitle));
            }
            ((World)event.getDestination().getExtent()).loadChunk(event.getDestination().getChunkPosition(), true);
            if (player.hasPermission("pjp.cmd.back")) {
                CMDBack.players.put(player, (Location<World>)src);
            }
        }
        finally {
            this.timings.onTeleportEventLocal().stopTimingIfSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onMoveEntityEvent(MoveEntityEvent.Teleport event, @Getter(value="getTargetEntity") Player player) {
        this.timings.onMoveEntityEvent().startTimingIfSync();
        try {
            World to;
            World from;
            if (player.hasPermission("pjp.cmd.back")) {
                CMDBack.players.put(player, (Location<World>)event.getFromTransform().getLocation());
            }
            if (!(from = (World)event.getFromTransform().getExtent()).equals(to = (World)event.getToTransform().getExtent())) {
                HashMap<String, Coordinate> list = new HashMap<String, Coordinate>();
                Optional optionalList = player.get(Keys.LAST_LOCATIONS);
                if (optionalList.isPresent()) {
                    list = (Map)optionalList.get();
                }
                list.put(from.getUniqueId().toString(), new Coordinate((Location<World>)event.getFromTransform().getLocation()));
                player.offer((ValueContainer)new LastLocationData(list));
            }
        }
        finally {
            this.timings.onMoveEntityEvent().stopTimingIfSync();
        }
    }

    @Listener
    public void onDestructEntityEventDeath(DestructEntityEvent.Death event, @Getter(value="getTargetEntity") Player player) {
        this.timings.onDestructEntityEventDeath().startTiming();
        try {
            if (player.hasPermission("pjp.cmd.back")) {
                CMDBack.players.put(player, (Location<World>)player.getLocation());
            }
        }
        finally {
            this.timings.onDestructEntityEventDeath().stopTimingIfSync();
        }
    }
}

