/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.listeners;

import com.gmail.trentech.pjp.data.Keys;
import com.gmail.trentech.pjp.data.mutable.SignPortalData;
import com.gmail.trentech.pjp.effects.Particle;
import com.gmail.trentech.pjp.effects.Particles;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.PortalService;
import com.gmail.trentech.pjp.utils.Timings;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.tileentity.ChangeSignEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SignListener {
    public static ConcurrentHashMap<UUID, Portal> builders = new ConcurrentHashMap();
    private Timings timings;

    public SignListener(Timings timings) {
        this.timings = timings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onChangeSignEvent(ChangeSignEvent event, @Root Player player) {
        this.timings.onChangeSignEvent().startTiming();
        try {
            if (!builders.containsKey(player.getUniqueId())) {
                return;
            }
            Portal portal = builders.get(player.getUniqueId());
            if (!player.hasPermission("pjp.sign.place")) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "You do not have permission to place sign portals"}));
                event.setCancelled(true);
                return;
            }
            event.getTargetTile().offer((ValueContainer)new SignPortalData(portal));
            Particle particle = Particles.getDefaultEffect("creation");
            particle.spawnParticle((Location<World>)event.getTargetTile().getLocation(), false, Particles.getDefaultColor("creation", particle.isColorable()));
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "New sign portal created"}));
            builders.remove(player.getUniqueId());
        }
        finally {
            this.timings.onChangeSignEvent().stopTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onInteractBlockEventSecondary(InteractBlockEvent.Secondary event, @Root Player player) {
        this.timings.onChangeSignEvent().startTiming();
        try {
            BlockSnapshot snapshot = event.getTargetBlock();
            if (!snapshot.getState().getType().equals(BlockTypes.WALL_SIGN) && !snapshot.getState().getType().equals(BlockTypes.STANDING_SIGN)) {
                return;
            }
            Location location = (Location)snapshot.getLocation().get();
            Optional optionalPortal = location.get(Keys.PORTAL);
            if (!optionalPortal.isPresent()) {
                return;
            }
            Portal portal = (Portal)optionalPortal.get();
            ((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).execute(player, portal);
        }
        finally {
            this.timings.onChangeSignEvent().stopTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onChangeBlockEventBreak(ChangeBlockEvent.Break event, @Root Player player) {
        this.timings.onChangeBlockEventBreak().startTiming();
        try {
            for (Transaction blockTransaction : event.getTransactions()) {
                Optional optionalPortal;
                BlockSnapshot snapshot = (BlockSnapshot)blockTransaction.getOriginal();
                BlockType blockType = snapshot.getState().getType();
                if (!blockType.equals(BlockTypes.WALL_SIGN) && !blockType.equals(BlockTypes.STANDING_SIGN) || !(optionalPortal = snapshot.get(Keys.PORTAL)).isPresent()) continue;
                if (!player.hasPermission("pjp.sign.break")) {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "You do not have permission to break sign portal"}));
                    event.setCancelled(true);
                    continue;
                }
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Broke sign portal"}));
            }
        }
        finally {
            this.timings.onChangeBlockEventBreak().stopTiming();
        }
    }
}

