/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.listeners;

import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.PortalService;
import com.gmail.trentech.pjp.utils.Timings;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class PlateListener {
    public static ConcurrentHashMap<UUID, Portal> builders = new ConcurrentHashMap();
    private Timings timings;

    public PlateListener(Timings timings) {
        this.timings = timings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onChangeBlockEventModify(ChangeBlockEvent.Modify event, @Root Player player) {
        this.timings.onChangeBlockEventModify().startTiming();
        try {
            for (Transaction transaction : event.getTransactions()) {
                BlockSnapshot snapshot = (BlockSnapshot)transaction.getFinal();
                BlockState block = snapshot.getExtendedState();
                BlockType blockType = block.getType();
                if (!blockType.equals(BlockTypes.HEAVY_WEIGHTED_PRESSURE_PLATE) && !blockType.equals(BlockTypes.LIGHT_WEIGHTED_PRESSURE_PLATE) && !blockType.equals(BlockTypes.STONE_PRESSURE_PLATE) && !blockType.equals(BlockTypes.WOODEN_PRESSURE_PLATE) || !block.get(Keys.POWERED).isPresent() || !((Boolean)block.get(Keys.POWERED).get()).booleanValue()) continue;
                Location location = (Location)snapshot.getLocation().get();
                PortalService portalService = (PortalService)Sponge.getServiceManager().provide(PortalService.class).get();
                Optional<Portal> optionalPortal = portalService.get((Location<World>)location, Portal.PortalType.PLATE);
                if (!optionalPortal.isPresent()) continue;
                Portal portal = optionalPortal.get();
                portalService.execute(player, portal);
            }
        }
        finally {
            this.timings.onChangeBlockEventModify().stopTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onChangeBlockEventBreak(ChangeBlockEvent.Break event, @Root Player player) {
        this.timings.onChangeBlockEventBreak().startTiming();
        try {
            for (Transaction transaction : event.getTransactions()) {
                Location location = (Location)((BlockSnapshot)transaction.getFinal()).getLocation().get();
                PortalService portalService = (PortalService)Sponge.getServiceManager().provide(PortalService.class).get();
                Optional<Portal> optionalPortal = portalService.get((Location<World>)location, Portal.PortalType.PLATE);
                if (!optionalPortal.isPresent()) continue;
                Portal portal = optionalPortal.get();
                if (!player.hasPermission("pjp.plate.break")) {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "you do not have permission to break pressure plate portals"}));
                    event.setCancelled(true);
                    continue;
                }
                portalService.remove(portal);
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Broke pressure plate portal"}));
            }
        }
        finally {
            this.timings.onChangeBlockEventBreak().stopTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onChangeBlockEventPlace(ChangeBlockEvent.Place event, @Root Player player) {
        this.timings.onChangeBlockEventPlace().startTiming();
        try {
            if (!builders.containsKey(player.getUniqueId())) {
                return;
            }
            for (Transaction transaction : event.getTransactions()) {
                BlockType blockType = ((BlockSnapshot)transaction.getFinal()).getState().getType();
                if (!blockType.equals(BlockTypes.HEAVY_WEIGHTED_PRESSURE_PLATE) && !blockType.equals(BlockTypes.LIGHT_WEIGHTED_PRESSURE_PLATE) && !blockType.equals(BlockTypes.STONE_PRESSURE_PLATE) && !blockType.equals(BlockTypes.WOODEN_PRESSURE_PLATE)) continue;
                Location location = (Location)((BlockSnapshot)transaction.getFinal()).getLocation().get();
                if (!player.hasPermission("pjp.plate.place")) {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "you do not have permission to place pressure plate portals"}));
                    builders.remove(player.getUniqueId());
                    event.setCancelled(true);
                    return;
                }
                Portal portal = builders.get(player.getUniqueId());
                ((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).create(portal, (Location<World>)location);
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "New pressure plate portal created"}));
                builders.remove(player.getUniqueId());
            }
        }
        finally {
            this.timings.onChangeBlockEventPlace().stopTiming();
        }
    }
}

