/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.listeners;

import com.gmail.trentech.pjp.Main;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.PortalService;
import com.gmail.trentech.pjp.utils.Timings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class DoorListener {
    public static ConcurrentHashMap<UUID, Portal> builders = new ConcurrentHashMap();
    private Timings timings;
    private static List<UUID> cache = new ArrayList<UUID>();

    public DoorListener(Timings timings) {
        this.timings = timings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onChangeBlockEventBreak(ChangeBlockEvent.Break event, @Root Player player) {
        this.timings.onChangeBlockEventBreak().startTiming();
        try {
            for (Transaction transaction : event.getTransactions()) {
                Location location = (Location)((BlockSnapshot)transaction.getFinal()).getLocation().get();
                PortalService portalService = (PortalService)Sponge.getServiceManager().provide(PortalService.class).get();
                Optional<Portal> optionalPortal = portalService.get((Location<World>)location, Portal.PortalType.DOOR);
                if (!optionalPortal.isPresent()) continue;
                Portal portal = optionalPortal.get();
                if (!player.hasPermission("pjp.door.break")) {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "you do not have permission to break door portals"}));
                    event.setCancelled(true);
                    continue;
                }
                portalService.remove(portal);
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Broke door portal"}));
            }
        }
        finally {
            this.timings.onChangeBlockEventBreak().stopTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener(order=Order.POST)
    public void onChangeBlockEventPlace(ChangeBlockEvent.Place event, @Root Player player) {
        this.timings.onChangeBlockEventPlace().startTiming();
        try {
            if (!builders.containsKey(player.getUniqueId())) {
                return;
            }
            for (Transaction transaction : event.getTransactions()) {
                Location location = (Location)((BlockSnapshot)transaction.getFinal()).getLocation().get();
                Optional optionalOpen = location.get(Keys.OPEN);
                if (!optionalOpen.isPresent()) continue;
                if (!player.hasPermission("pjp.door.place")) {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "you do not have permission to place door portals"}));
                    builders.remove(player.getUniqueId());
                    event.setCancelled(true);
                    return;
                }
                Portal portal = builders.get(player.getUniqueId());
                ((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).create(portal, (Location<World>)location);
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "New door portal created"}));
                builders.remove(player.getUniqueId());
                break;
            }
        }
        finally {
            this.timings.onChangeBlockEventPlace().stopTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onMoveEntityEventPlayer(MoveEntityEvent event, @Getter(value="getTargetEntity") Player player) {
        this.timings.onMoveEntityEvent().startTimingIfSync();
        try {
            Location location = player.getLocation();
            Optional optionalOpen = location.get(Keys.OPEN);
            if (!optionalOpen.isPresent()) {
                return;
            }
            if (!((Boolean)optionalOpen.get()).booleanValue()) {
                return;
            }
            PortalService portalService = (PortalService)Sponge.getServiceManager().provide(PortalService.class).get();
            Optional<Portal> optionalPortal = portalService.get((Location<World>)location, Portal.PortalType.DOOR);
            if (!optionalPortal.isPresent()) {
                return;
            }
            Portal portal = optionalPortal.get();
            UUID uuid = player.getUniqueId();
            if (cache.contains(uuid)) {
                return;
            }
            cache.add(uuid);
            portalService.execute(player, portal);
            Sponge.getScheduler().createTaskBuilder().delayTicks(20L).execute(c -> cache.remove(uuid)).submit((Object)Main.getPlugin());
        }
        finally {
            this.timings.onMoveEntityEvent().stopTimingIfSync();
        }
    }
}

