/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.data.mutable;

import com.gmail.trentech.pjp.data.Keys;
import com.gmail.trentech.pjp.data.immutable.ImmutableBedData;
import com.gmail.trentech.pjp.portal.features.Coordinate;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.mutable.common.AbstractMappedData;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.mutable.MapValue;

public class BedData
extends AbstractMappedData<String, Coordinate, BedData, ImmutableBedData> {
    public BedData(Map<String, Coordinate> value) {
        super(value, Keys.BED_LOCATIONS);
    }

    public BedData() {
        super(new HashMap(), Keys.BED_LOCATIONS);
    }

    public MapValue<String, Coordinate> portals() {
        return Sponge.getRegistry().getValueFactory().createMapValue(Keys.BED_LOCATIONS, this.getValue());
    }

    public Optional<Coordinate> get(String key) {
        if (this.getValue().containsKey(key)) {
            return Optional.of(this.getValue().get(key));
        }
        return Optional.empty();
    }

    public Set<String> getMapKeys() {
        return this.getValue().keySet();
    }

    public BedData put(String key, Coordinate value) {
        this.getValue().put(key, value);
        return this;
    }

    public BedData putAll(Map<? extends String, ? extends Coordinate> map) {
        this.getValue().putAll(map);
        return this;
    }

    public BedData remove(String key) {
        this.getValue().remove(key);
        return this;
    }

    public Optional<BedData> fill(DataHolder dataHolder, MergeFunction mergeFn) {
        BedData coordinateData = (BedData)((MergeFunction)Preconditions.checkNotNull((Object)mergeFn)).merge((ValueContainer)this.copy(), (ValueContainer)dataHolder.get(BedData.class).orElse(this.copy()));
        return Optional.of(this.set(Keys.BED_LOCATIONS, coordinateData.get(Keys.BED_LOCATIONS).get()));
    }

    public Optional<BedData> from(DataContainer container) {
        if (container.contains(Keys.BED_LOCATIONS.getQuery())) {
            HashMap<String, Coordinate> coordinateList = new HashMap<String, Coordinate>();
            DataView coordinates = (DataView)container.getView(Keys.BED_LOCATIONS.getQuery()).get();
            for (DataQuery coordinate : coordinates.getKeys(false)) {
                Optional optionalCoordinate = coordinates.getSerializable(coordinate, Coordinate.class);
                if (!optionalCoordinate.isPresent()) continue;
                coordinateList.put(coordinate.toString(), (Coordinate)optionalCoordinate.get());
            }
            return Optional.of(new BedData(coordinateList));
        }
        return Optional.empty();
    }

    public BedData copy() {
        return new BedData(this.getValue());
    }

    public int getContentVersion() {
        return 0;
    }

    public ImmutableBedData asImmutable() {
        return new ImmutableBedData(this.getValue());
    }

    public DataContainer toContainer() {
        return super.toContainer().set(Keys.BED_LOCATIONS, (Object)this.getValue());
    }

    public static class Builder
    extends AbstractDataBuilder<BedData>
    implements DataManipulatorBuilder<BedData, ImmutableBedData> {
        public Builder() {
            super(BedData.class, 0);
        }

        public Optional<BedData> buildContent(DataView container) throws InvalidDataException {
            if (container.contains(Keys.BED_LOCATIONS.getQuery())) {
                HashMap<String, Coordinate> coordinateList = new HashMap<String, Coordinate>();
                DataView coordinates = (DataView)container.getView(Keys.BED_LOCATIONS.getQuery()).get();
                for (DataQuery coordinate : coordinates.getKeys(false)) {
                    Optional optionalCoordinate = coordinates.getSerializable(coordinate, Coordinate.class);
                    if (!optionalCoordinate.isPresent()) continue;
                    coordinateList.put(coordinate.toString(), (Coordinate)optionalCoordinate.get());
                }
                return Optional.of(new BedData(coordinateList));
            }
            return Optional.empty();
        }

        public BedData create() {
            return new BedData(new HashMap<String, Coordinate>());
        }

        public Optional<BedData> createFrom(DataHolder dataHolder) {
            return this.create().fill(dataHolder);
        }
    }
}

