/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.commands.portal;

import com.flowpowered.math.vector.Vector3d;
import com.gmail.trentech.pjc.core.BungeeManager;
import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.PortalService;
import com.gmail.trentech.pjp.portal.features.Coordinate;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public class CMDDestination
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Help help = (Help)Help.get((String)"portal destination").get();
        if (args.hasAny("help")) {
            help.execute(src);
            return CommandResult.empty();
        }
        if (!(src instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Must be a player"}), false);
        }
        Player player = (Player)src;
        if (!args.hasAny("name")) {
            throw new CommandException(Text.builder().onClick((ClickAction)TextActions.executeCallback((Consumer)help.execute())).append(new Text[]{help.getUsageText()}).build(), false);
        }
        Portal portal = (Portal)args.getOne("name").get();
        if (!args.hasAny("destination")) {
            throw new CommandException(Text.builder().onClick((ClickAction)TextActions.executeCallback((Consumer)help.execute())).append(new Text[]{help.getUsageText()}).build(), false);
        }
        String destination = (String)args.getOne("destination").get();
        if (portal instanceof Portal.Server) {
            Portal.Server server = (Portal.Server)portal;
            Consumer<List> consumer1 = list -> {
                if (!list.contains(destination)) {
                    try {
                        throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, destination, " does not exist"}), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Consumer<String> consumer2 = s -> {
                    if (destination.equalsIgnoreCase((String)s)) {
                        try {
                            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Destination cannot be the server you are currently on"}), false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                BungeeManager.getServer(consumer2, (Player)player);
            };
            BungeeManager.getServers(consumer1, (Player)player);
            server.setServer(destination);
        } else {
            Coordinate coordinate;
            Portal.Local local = (Portal.Local)portal;
            Optional world = Sponge.getServer().getWorld(destination);
            if (!world.isPresent()) {
                throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, destination, " is not loaded or does not exist"}), false);
            }
            if (args.hasAny("x,y,z")) {
                String[] coords = ((String)args.getOne("x,y,z").get()).split(",");
                if (coords[0].equalsIgnoreCase("random")) {
                    coordinate = new Coordinate((World)world.get(), Coordinate.Preset.RANDOM);
                } else if (coords[0].equalsIgnoreCase("bed")) {
                    coordinate = new Coordinate((World)world.get(), Coordinate.Preset.BED);
                } else if (coords[0].equalsIgnoreCase("last")) {
                    coordinate = new Coordinate((World)world.get(), Coordinate.Preset.LAST_LOCATION);
                } else {
                    try {
                        coordinate = new Coordinate((World)world.get(), new Vector3d(Double.parseDouble(coords[0]), Double.parseDouble(coords[1]), Double.parseDouble(coords[2])));
                    }
                    catch (Exception e) {
                        throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, coords.toString(), " is not valid"}), true);
                    }
                }
            } else {
                coordinate = new Coordinate((World)world.get(), Coordinate.Preset.NONE);
            }
            local.setCoordinate(coordinate);
        }
        ((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).update(portal);
        src.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Portal destination updated"}));
        return CommandResult.success();
    }
}

