/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.commands;

import com.flowpowered.math.vector.Vector3d;
import com.gmail.trentech.pjc.core.BungeeManager;
import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjp.portal.features.Command;
import com.gmail.trentech.pjp.portal.features.Coordinate;
import com.gmail.trentech.pjp.rotation.Rotation;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public abstract class CMDObjBase
implements CommandExecutor {
    String name;

    public CMDObjBase(String name) {
        this.name = name;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Help help = (Help)Help.get((String)this.name).get();
        if (args.hasAny("help")) {
            help.execute(src);
            return CommandResult.empty();
        }
        if (!(src instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Must be a player"}), false);
        }
        Player player = (Player)src;
        if (!args.hasAny("destination")) {
            throw new CommandException(Text.builder().onClick((ClickAction)TextActions.executeCallback((Consumer)help.execute())).append(new Text[]{help.getUsageText()}).build(), false);
        }
        String destination = (String)args.getOne("destination").get();
        Optional<Coordinate> coordinate = Optional.empty();
        AtomicReference<Rotation> direction = new AtomicReference<Rotation>(Rotation.EAST);
        AtomicReference<Double> price = new AtomicReference<Double>(0.0);
        boolean force = false;
        Optional permission = args.getOne("permission");
        AtomicReference command = new AtomicReference(Optional.empty());
        if (args.hasAny("price")) {
            price.set((Double)args.getOne("price").get());
        }
        if (args.hasAny("command")) {
            String rawCommand = (String)args.getOne("command").get();
            String source = rawCommand.substring(0, 2);
            if (rawCommand.length() < 2) {
                throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Did not specify command source. P: for player or C: for console. Example \"P:say hello world\""}), false);
            }
            if (source.equalsIgnoreCase("P:")) {
                command.set(Optional.of(new Command(Command.SourceType.PLAYER, rawCommand.substring(2))));
            } else if (source.equalsIgnoreCase("C:")) {
                command.set(Optional.of(new Command(Command.SourceType.CONSOLE, rawCommand.substring(2))));
            } else {
                throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Did not specify command source. P: for player or C: for console. Example \"P:say hello world\""}), false);
            }
        }
        if (args.hasAny("b")) {
            Consumer<List> consumer1 = list -> {
                if (!list.contains(destination)) {
                    try {
                        throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, destination, " does not exist"}), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Consumer<String> consumer2 = s -> {
                    if (destination.equalsIgnoreCase((String)s)) {
                        try {
                            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Destination cannot be the server you are currently on"}), false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.init(player, (Rotation)((Object)((Object)((Object)direction.get()))), (Double)price.get(), false, Optional.of(destination), Optional.empty(), permission, (Optional)command.get());
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Place " + this.name + " to create " + this.name + " portal"}));
                };
                BungeeManager.getServer(consumer2, (Player)player);
            };
            BungeeManager.getServers(consumer1, (Player)player);
        } else {
            Optional world = Sponge.getServer().getWorld(destination);
            if (!world.isPresent()) {
                throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, destination, " is not loaded or does not exist"}), false);
            }
            if (args.hasAny("x,y,z")) {
                String[] coords = ((String)args.getOne("x,y,z").get()).split(",");
                if (coords[0].equalsIgnoreCase("random")) {
                    coordinate = Optional.of(new Coordinate((World)world.get(), Coordinate.Preset.RANDOM));
                } else if (coords[0].equalsIgnoreCase("bed")) {
                    coordinate = Optional.of(new Coordinate((World)world.get(), Coordinate.Preset.BED));
                } else if (coords[0].equalsIgnoreCase("last")) {
                    coordinate = Optional.of(new Coordinate((World)world.get(), Coordinate.Preset.LAST_LOCATION));
                } else {
                    try {
                        coordinate = Optional.of(new Coordinate((World)world.get(), new Vector3d(Double.parseDouble(coords[0]), Double.parseDouble(coords[1]), Double.parseDouble(coords[2]))));
                    }
                    catch (Exception e) {
                        throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, coords.toString(), " is not valid"}), true);
                    }
                }
            } else {
                coordinate = Optional.of(new Coordinate((World)world.get(), Coordinate.Preset.NONE));
            }
            if (args.hasAny("direction")) {
                direction.set((Rotation)((Object)args.getOne("direction").get()));
            }
            if (args.hasAny("f")) {
                force = true;
            }
            this.init(player, direction.get(), price.get(), force, Optional.empty(), coordinate, permission, command.get());
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Place " + this.name + " to create " + this.name + " portal"}));
        }
        return CommandResult.success();
    }

    protected abstract void init(Player var1, Rotation var2, double var3, boolean var5, Optional<String> var6, Optional<Coordinate> var7, Optional<String> var8, Optional<Command> var9);
}

