/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.listeners;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionHome;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.listeners.AbstractListener;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.ArmorStand;
import org.spongepowered.api.entity.living.Hostile;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnType;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class EntitySpawnListener
extends AbstractListener {
    private final FactionsConfig factionsConfig;
    private final ProtectionConfig protectionConfig;

    public EntitySpawnListener(EagleFactions plugin) {
        super(plugin);
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
        this.protectionConfig = plugin.getConfiguration().getProtectionConfig();
    }

    @Listener(order=Order.EARLY, beforeModifications=true)
    public void onEntitySpawn(SpawnEntityEvent event) {
        Cause cause = event.getCause();
        Object rootCause = cause.root();
        EventContext eventContext = event.getContext();
        SpawnType spawnType = eventContext.get(EventContextKeys.SPAWN_TYPE).orElse(null);
        boolean isPlayerPlace = eventContext.get(EventContextKeys.PLAYER_PLACE).isPresent() && eventContext.get(EventContextKeys.OWNER).isPresent();
        boolean isItemUsed = eventContext.get(EventContextKeys.USED_ITEM).isPresent() && eventContext.get(EventContextKeys.OWNER).isPresent();
        for (Entity entity : event.getEntities()) {
            Optional<Faction> optionalFaction;
            User user;
            Entity causeEntity;
            String entityId;
            if (rootCause instanceof Entity && (entityId = (causeEntity = (Entity)rootCause).getType().getId()).contains("mininglaser") && eventContext.containsKey(EventContextKeys.OWNER)) {
                User user2 = (User)eventContext.get(EventContextKeys.OWNER).get();
                Entity miningLaser = (Entity)rootCause;
                if (!super.getPlugin().getProtectionManager().canExplode((Location<World>)miningLaser.getLocation(), user2, false)) {
                    event.setCancelled(true);
                    continue;
                }
            }
            if (entity.toString().contains("EntityCustomNpc")) {
                return;
            }
            if (isItemUsed) {
                user = (User)eventContext.get(EventContextKeys.OWNER).get();
                ItemStackSnapshot itemStackSnapshot = (ItemStackSnapshot)eventContext.get(EventContextKeys.USED_ITEM).get();
                if (!super.getPlugin().getProtectionManager().canUseItem((Location<World>)entity.getLocation(), user, itemStackSnapshot, true)) {
                    event.setCancelled(true);
                    return;
                }
            } else if (spawnType == SpawnTypes.PLACEMENT && isPlayerPlace) {
                user = (User)eventContext.get(EventContextKeys.OWNER).get();
                if (!super.getPlugin().getProtectionManager().canPlace((Location<World>)entity.getLocation(), user, false)) {
                    event.setCancelled(true);
                    return;
                }
            }
            boolean isHostile = entity instanceof Hostile;
            boolean isPlayer = entity instanceof Player;
            boolean isLiving = entity instanceof Living;
            if (!(isHostile || isPlayer || isLiving)) {
                return;
            }
            if (isPlayer) {
                if (this.factionsConfig.shouldSpawnAtHomeAfterDeath()) {
                    Player player = (Player)entity;
                    Optional<Faction> optionalPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
                    if (!optionalPlayerFaction.isPresent()) {
                        return;
                    }
                    Faction faction = optionalPlayerFaction.get();
                    FactionHome factionHome = faction.getHome();
                    if (factionHome != null) {
                        event.setCancelled(true);
                        World world = (World)Sponge.getServer().getWorld(factionHome.getWorldUUID()).get();
                        player.setLocation(new Location((Extent)world, factionHome.getBlockPosition()));
                        return;
                    }
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.COULD_NOT_SPAWN_AT_FACTIONS_HOME_HOME_MAY_NOT_BE_SET}));
                }
                return;
            }
            if (isHostile) {
                if (this.protectionConfig.getSafeZoneWorldNames().contains(entity.getWorld().getName())) {
                    event.setCancelled(true);
                    return;
                }
                if (this.protectionConfig.getWarZoneWorldNames().contains(entity.getWorld().getName()) && !this.protectionConfig.canSpawnHostileMobsInWarZone()) {
                    event.setCancelled(true);
                    return;
                }
                optionalFaction = super.getPlugin().getFactionLogic().getFactionByChunk(entity.getWorld().getUniqueId(), entity.getLocation().getChunkPosition());
                if (!optionalFaction.isPresent()) {
                    return;
                }
                Faction faction = optionalFaction.get();
                if (faction.isSafeZone()) {
                    event.setCancelled(true);
                    return;
                }
                if (faction.isWarZone() && !this.protectionConfig.canSpawnHostileMobsInWarZone()) {
                    event.setCancelled(true);
                    return;
                }
                if (!this.protectionConfig.canSpawnHostileMobsInFactionsTerritory()) {
                    event.setCancelled(true);
                    return;
                }
                return;
            }
            if (!isLiving) continue;
            if (entity instanceof ArmorStand) {
                return;
            }
            if (this.protectionConfig.getSafeZoneWorldNames().contains(entity.getWorld().getName()) && !this.protectionConfig.canSpawnMobsInSafeZone()) {
                event.setCancelled(true);
                return;
            }
            if (this.protectionConfig.getWarZoneWorldNames().contains(entity.getWorld().getName()) && !this.protectionConfig.canSpawnMobsInWarZone()) {
                event.setCancelled(true);
                return;
            }
            optionalFaction = super.getPlugin().getFactionLogic().getFactionByChunk(entity.getWorld().getUniqueId(), entity.getLocation().getChunkPosition());
            if (!optionalFaction.isPresent()) {
                return;
            }
            Faction faction = optionalFaction.get();
            if (faction.isSafeZone() && !this.protectionConfig.canSpawnMobsInSafeZone()) {
                event.setCancelled(true);
                return;
            }
            if (faction.isWarZone() && !this.protectionConfig.canSpawnMobsInWarZone()) {
                event.setCancelled(true);
                return;
            }
            if (!this.protectionConfig.canSpawnMobsInFactionsTerritory()) {
                event.setCancelled(true);
                return;
            }
            return;
        }
    }
}

