/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcrestrict;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.moddedminecraft.mmcrestrict.Data.ItemData;
import net.moddedminecraft.mmcrestrict.Main;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.carrier.TileEntityCarrier;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.event.item.inventory.CraftItemEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;

public class EventListener {
    private Main plugin;

    public EventListener(Main instance) {
        this.plugin = instance;
    }

    @Listener
    public void onPlayerJoin(ClientConnectionEvent.Join event, @Root Player player) {
        this.checkInventory(player);
    }

    @Listener
    public void onItemPickup(ChangeInventoryEvent.Pickup event, @Root Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        for (SlotTransaction transaction : event.getTransactions()) {
            ItemStack itemStack = ((ItemStackSnapshot)transaction.getFinal()).createStack();
            if (itemStack.getType().equals(ItemTypes.NONE) || !this.checkBanned(itemStack, "own", player)) continue;
            event.setCancelled(true);
        }
    }

    @Listener
    public void onItemDrop(DropItemEvent.Pre event, @Root Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        List itemIDs = event.getDroppedItems();
        for (ItemStackSnapshot itemSnapshot : itemIDs) {
            ItemStack itemStack = itemSnapshot.createStack();
            if (itemStack.getType().equals(ItemTypes.NONE) || !this.checkBanned(itemStack, "drop", player)) continue;
            event.setCancelled(true);
        }
    }

    @Listener
    public void InteractItemEvent(InteractItemEvent event, @Root Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        ItemStack itemStack = event.getItemStack().createStack();
        if (this.checkBanned(itemStack, "use", player)) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onBlockPlace(ChangeBlockEvent.Place event, @Root Player player) {
        if (((BlockSnapshot)((Transaction)event.getTransactions().get(0)).getFinal()).getState().getType().equals(BlockTypes.AIR)) {
            return;
        }
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        BlockSnapshot targetBlock = (BlockSnapshot)((Transaction)event.getTransactions().get(0)).getFinal();
        if (this.checkBanned(targetBlock, "place", player)) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onBlockBreak(ChangeBlockEvent.Break event, @Root Player player) {
        if (((BlockSnapshot)((Transaction)event.getTransactions().get(0)).getFinal()).getState().getType().equals(BlockTypes.AIR)) {
            return;
        }
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        BlockSnapshot targetBlock = (BlockSnapshot)((Transaction)event.getTransactions().get(0)).getFinal();
        if (this.checkBanned(targetBlock, "break", player)) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onBlockModify(ChangeBlockEvent.Modify event, @Root Player player) {
        if (((BlockSnapshot)((Transaction)event.getTransactions().get(0)).getFinal()).getState().getType().equals(BlockTypes.AIR)) {
            return;
        }
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        BlockSnapshot targetBlock = (BlockSnapshot)((Transaction)event.getTransactions().get(0)).getFinal();
        if (this.checkBanned(targetBlock, "use", player)) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onLeftClick(InteractBlockEvent.Primary.MainHand event, @Root Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        BlockSnapshot targetBlock = event.getTargetBlock();
        if (this.checkBanned(targetBlock, "use", player)) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onEntityInteract(InteractEntityEvent.Secondary.MainHand event, @Root Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        ItemStack itemStack = ((ItemStack)player.getItemInHand(HandTypes.MAIN_HAND).get()).createSnapshot().createStack();
        if (this.checkBanned(itemStack, "use", player)) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onEntityInteract(InteractEntityEvent.Secondary.OffHand event, @Root Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        ItemStack itemStack = ((ItemStack)player.getItemInHand(HandTypes.OFF_HAND).get()).createSnapshot().createStack();
        if (this.checkBanned(itemStack, "use", player)) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onEntityInteract(InteractEntityEvent.Primary.MainHand event, @Root Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        ItemStack itemStack = ((ItemStack)player.getItemInHand(HandTypes.MAIN_HAND).get()).createSnapshot().createStack();
        if (this.checkBanned(itemStack, "use", player)) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onEntityInteract(InteractEntityEvent.Primary.OffHand event, @Root Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        ItemStack itemStack = ((ItemStack)player.getItemInHand(HandTypes.OFF_HAND).get()).createSnapshot().createStack();
        if (this.checkBanned(itemStack, "use", player)) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onRightClick(InteractBlockEvent.Secondary.MainHand event, @Root Player player) {
        boolean sneaking = player.get(Keys.IS_SNEAKING).orElse(false);
        if (player.hasPermission("mmcrestrict.commands.add") && event.getTargetBlock().getState().getType().equals(BlockTypes.CHEST) && sneaking && player.getItemInHand(HandTypes.MAIN_HAND).isPresent() && ((ItemStack)player.getItemInHand(HandTypes.MAIN_HAND).get()).getType().getType().equals(ItemTypes.FLINT)) {
            TileEntityCarrier chest = (TileEntityCarrier)((Location)event.getTargetBlock().getLocation().get()).getTileEntity().get();
            for (Inventory slot : chest.getInventory().slots()) {
                if (!slot.peek().isPresent()) continue;
                DataContainer container = ((ItemStack)slot.peek().get()).toContainer();
                DataQuery query = DataQuery.of((char)'/', (String)"UnsafeDamage");
                int unsafeDamage = 0;
                if (container.get(query).isPresent()) {
                    unsafeDamage = Integer.parseInt(container.get(query).get().toString());
                }
                String itemId = ((ItemStack)slot.peek().get()).getType().getId();
                if (unsafeDamage != 0) {
                    itemId = itemId + ":" + unsafeDamage;
                }
                String itemID = itemId;
                String itemName = ((ItemStack)slot.peek().get()).getTranslation().get();
                this.plugin.checkChestItem(itemID, itemName, player.getName());
            }
            try {
                this.plugin.saveData();
            }
            catch (Exception e) {
                player.sendMessage((Text)Text.of((String)"Data was not saved correctly."));
                e.printStackTrace();
            }
            player.sendMessage((Text)Text.of((String)"Chest items were added to the list."));
            return;
        }
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        BlockSnapshot targetBlock = event.getTargetBlock();
        if (this.checkBanned(targetBlock, "use", player)) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onLeftClick(InteractBlockEvent.Primary.OffHand event, @Root Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        BlockSnapshot targetBlock = event.getTargetBlock();
        if (this.checkBanned(targetBlock, "use", player)) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onRightClick(InteractBlockEvent.Secondary.OffHand event, @Root Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        BlockSnapshot targetBlock = event.getTargetBlock();
        if (this.checkBanned(targetBlock, "use", player)) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onCraftItemEvent(CraftItemEvent.Preview event, @Root Player player) {
        ItemStack itemStack;
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        if (!((ItemStackSnapshot)event.getPreview().getFinal()).isEmpty() && this.checkBanned(itemStack = ((ItemStackSnapshot)event.getPreview().getFinal()).createStack(), "craft", player)) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onChangeEquipment(ChangeInventoryEvent.Equipment event, @Root Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        for (SlotTransaction transaction : event.getTransactions()) {
            ItemStack itemStack = ((ItemStackSnapshot)transaction.getFinal()).createStack();
            if (itemStack.getType().equals(ItemTypes.NONE) || !this.checkBanned(itemStack, "own", player)) continue;
            event.setCancelled(true);
        }
    }

    @Listener
    public void onChangeHeld(ChangeInventoryEvent.Held event, @Root Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        for (SlotTransaction transaction : event.getTransactions()) {
            ItemStack itemStack = ((ItemStackSnapshot)transaction.getFinal()).createStack();
            if (itemStack.getType().equals(ItemTypes.NONE) || !this.checkBanned(itemStack, "own", player)) continue;
            event.setCancelled(true);
        }
    }

    @Listener
    public void onClickInventoryEvent(ClickInventoryEvent event, final @Root Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        if (event instanceof ClickInventoryEvent.Shift) {
            for (SlotTransaction transaction : event.getTransactions()) {
                ItemStack itemStack = ((ItemStackSnapshot)transaction.getFinal()).createStack();
                if (!this.checkBanned(itemStack, "own", player)) continue;
                event.setCancelled(true);
                Sponge.getScheduler().createTaskBuilder().execute(new Runnable(){

                    @Override
                    public void run() {
                        EventListener.this.checkInventory(player);
                    }
                }).delay(1L, TimeUnit.SECONDS).name("mmcrestrict-s-onclickinventoryevent").submit((Object)this.plugin);
            }
        } else {
            ItemStack itemStack = ((ItemStackSnapshot)event.getCursorTransaction().getFinal()).createStack();
            if (this.checkBanned(itemStack, "own", player)) {
                event.setCancelled(true);
                Sponge.getScheduler().createTaskBuilder().execute(new Runnable(){

                    @Override
                    public void run() {
                        EventListener.this.checkInventory(player);
                    }
                }).delay(1L, TimeUnit.SECONDS).name("mmcrestrict-s-onclickinventoryevent").submit((Object)this.plugin);
            }
        }
    }

    private boolean checkBanned(ItemStack itemStack, String banType, Player player) {
        ArrayList<ItemData> items = new ArrayList<ItemData>(this.plugin.getItemData());
        DataContainer container = itemStack.toContainer();
        DataQuery query = DataQuery.of((char)'/', (String)"UnsafeDamage");
        String itemID = itemStack.getType().getId();
        int unsafeDamage = 0;
        if (container.get(query).isPresent()) {
            unsafeDamage = Integer.parseInt(container.get(query).get().toString());
        }
        if (unsafeDamage != 0) {
            itemID = itemID + ":" + unsafeDamage;
        }
        for (ItemData item : items) {
            if (!item.getItemid().equalsIgnoreCase(itemID) || !(banType.equalsIgnoreCase("craft") && item.getCraftbanned() != false || banType.equalsIgnoreCase("break") && item.getBreakingbanned() != false || banType.equalsIgnoreCase("drop") && item.getDropbanned() != false || banType.equalsIgnoreCase("own") && item.getOwnershipbanned() != false || banType.equalsIgnoreCase("place") && item.getPlacingbanned() != false) && (!banType.equalsIgnoreCase("use") || !item.getUsagebanned().booleanValue()) || !this.plugin.checkPerm((CommandSource)player, banType.toLowerCase(), itemID)) continue;
            String reason = "";
            if (!item.getBanreason().isEmpty()) {
                reason = " &3- &7" + item.getBanreason();
            }
            this.plugin.logToFile("action-log", player.getName() + " tried to " + banType.toLowerCase() + " " + item.getItemname());
            if (!banType.equalsIgnoreCase("own")) {
                this.plugin.notifyOnlineStaff(this.plugin.fromLegacy("&8[&6MMCRestrict&8] &c" + player.getName() + " tried to " + banType.toLowerCase() + " " + item.getItemname()));
            }
            player.sendMessage(this.plugin.fromLegacy("&c" + item.getItemname() + " is banned" + reason));
            this.checkInventory(player);
            return true;
        }
        return false;
    }

    private boolean checkBanned(BlockSnapshot blockSnapshot, String banType, Player player) {
        ArrayList<ItemData> items = new ArrayList<ItemData>(this.plugin.getItemData());
        String itemID = blockSnapshot.getExtendedState().getType().getId();
        for (ItemData item : items) {
            ItemStack itemStack;
            if (!item.getItemid().contains(itemID)) continue;
            try {
                itemStack = ItemStack.builder().fromBlockState(blockSnapshot.getState()).build();
            }
            catch (Exception e) {
                return false;
            }
            DataContainer container = itemStack.toContainer();
            DataQuery query = DataQuery.of((char)'/', (String)"UnsafeDamage");
            int unsafeDamage = 0;
            if (container.get(query).isPresent()) {
                unsafeDamage = Integer.parseInt(container.get(query).get().toString());
            }
            if (unsafeDamage != 0) {
                itemID = itemID + ":" + unsafeDamage;
            }
            if (!item.getItemid().equalsIgnoreCase(itemID) || !(banType.equalsIgnoreCase("craft") && item.getCraftbanned() != false || banType.equalsIgnoreCase("break") && item.getBreakingbanned() != false || banType.equalsIgnoreCase("drop") && item.getDropbanned() != false || banType.equalsIgnoreCase("own") && item.getOwnershipbanned() != false || banType.equalsIgnoreCase("place") && item.getPlacingbanned() != false) && (!banType.equalsIgnoreCase("use") || !item.getUsagebanned().booleanValue()) || !this.plugin.checkPerm((CommandSource)player, banType.toLowerCase(), itemID)) continue;
            String reason = "";
            if (!item.getBanreason().isEmpty()) {
                reason = " &3- &7" + item.getBanreason();
            }
            this.plugin.logToFile("action-log", player.getName() + " tried to " + banType.toLowerCase() + " " + item.getItemname());
            if (!banType.equalsIgnoreCase("own")) {
                this.plugin.notifyOnlineStaff(this.plugin.fromLegacy("&8[&6MMCRestrict&8] &c" + player.getName() + " tried to " + banType.toLowerCase() + " " + item.getItemname()));
            }
            player.sendMessage(this.plugin.fromLegacy("&c" + item.getItemname() + " is banned" + reason));
            this.checkInventory(player);
            return true;
        }
        return false;
    }

    private void checkInventory(Player player) {
        if (player.hasPermission("mmcrestrict.bypass")) {
            return;
        }
        ArrayList<ItemData> items = new ArrayList<ItemData>(this.plugin.getItemData());
        for (Inventory s : player.getInventory().slots()) {
            if (!s.peek().isPresent()) continue;
            ItemStack itemStack = (ItemStack)s.peek().get();
            String itemID = itemStack.getType().getId();
            DataContainer container = ((ItemStack)s.peek().get()).toContainer();
            DataQuery query = DataQuery.of((char)'/', (String)"UnsafeDamage");
            int unsafeDamage = 0;
            if (container.get(query).isPresent()) {
                unsafeDamage = Integer.parseInt(container.get(query).get().toString());
            }
            if (unsafeDamage != 0) {
                itemID = itemID + ":" + unsafeDamage;
            }
            for (ItemData item : items) {
                if (!item.getItemid().equalsIgnoreCase(itemID) || !item.getOwnershipbanned().booleanValue() || !this.plugin.checkPerm((CommandSource)player, "own", itemID)) continue;
                s.clear();
                String reason = "";
                if (!item.getBanreason().isEmpty()) {
                    reason = " &3- &7" + item.getBanreason();
                }
                this.plugin.logToFile("action-log", item.getItemname() + " was removed from " + player.getName() + "'s inventory");
                player.sendMessage(this.plugin.fromLegacy("&c" + item.getItemname() + " is banned and has been removed from your inventory" + reason));
            }
        }
    }
}

