/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Module;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.annotations.ModuleData;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.LoadingStatus;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.enums.ModulePhase;
import java.util.Arrays;
import java.util.List;

public final class ModuleSpec {
    private final Class<? extends Module> moduleClass;
    private final List<String> softDeps;
    private final List<String> deps;
    private final String name;
    private final String id;
    private final boolean runtimeDisableable;
    private LoadingStatus status;
    private final boolean isMandatory;
    private ModulePhase phase = ModulePhase.DISCOVERED;

    ModuleSpec(Class<? extends Module> moduleClass, ModuleData data) {
        this(moduleClass, data.id(), data.name(), data.status(), data.isRequired(), Arrays.asList(data.softDependencies()), Arrays.asList(data.dependencies()));
    }

    ModuleSpec(Class<? extends Module> moduleClass, String id, String name, LoadingStatus status, boolean isMandatory) {
        this(moduleClass, id, name, status, isMandatory, Lists.newArrayList(), Lists.newArrayList());
    }

    ModuleSpec(Class<? extends Module> moduleClass, String id, String name, LoadingStatus status, boolean isMandatory, List<String> softDeps, List<String> deps) {
        Preconditions.checkNotNull(moduleClass);
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)((Object)status));
        Preconditions.checkNotNull(deps);
        Preconditions.checkNotNull(softDeps);
        this.id = id;
        this.moduleClass = moduleClass;
        this.runtimeDisableable = Module.RuntimeDisableable.class.isAssignableFrom(moduleClass);
        this.name = name;
        this.status = isMandatory ? LoadingStatus.FORCELOAD : status;
        this.isMandatory = isMandatory;
        this.softDeps = softDeps;
        this.deps = deps;
    }

    public Class<? extends Module> getModuleClass() {
        return this.moduleClass;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public LoadingStatus getStatus() {
        return this.status;
    }

    void setStatus(LoadingStatus status) {
        Preconditions.checkState((boolean)this.phase.canSetLoadingPhase());
        Preconditions.checkState((!this.isMandatory ? 1 : 0) != 0);
        this.status = status;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public ModulePhase getPhase() {
        return this.phase;
    }

    void setPhase(ModulePhase phase) {
        this.phase = phase;
    }

    public List<String> getSoftDependencies() {
        return this.softDeps;
    }

    public List<String> getDependencies() {
        return this.deps;
    }

    public boolean isRuntimeAlterable() {
        return this.runtimeDisableable;
    }
}

