/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import com.flowpowered.math.vector.Vector3i;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.storage.WorldProperties;

@Permissions(prefix="world", suggestedLevel=SuggestedLevel.ADMIN)
@RegisterCommand(value={"setspawn"}, subcommandOf=WorldCommand.class)
@NonnullByDefault
public class SetSpawnWorldCommand
extends AbstractCommand<CommandSource> {
    private final String worldKey = "world";
    private final String xKey = "x";
    private final String yKey = "y";
    private final String zKey = "z";

    @Override
    protected CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.optional((CommandElement)GenericArguments.seq((CommandElement[])new CommandElement[]{GenericArguments.world((Text)Text.of((String)this.worldKey)), GenericArguments.integer((Text)Text.of((String)this.xKey)), GenericArguments.integer((Text)Text.of((String)this.yKey)), GenericArguments.integer((Text)Text.of((String)this.zKey))}))};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        WorldProperties world = this.getWorldFromUserOrArgs(src, this.worldKey, args);
        Vector3i loc = args.hasAny(this.xKey) ? new Vector3i(((Integer)args.getOne(this.xKey).get()).intValue(), ((Integer)args.getOne(this.yKey).get()).intValue(), ((Integer)args.getOne(this.zKey).get()).intValue()) : ((Locatable)src).getLocation().getBlockPosition();
        world.setSpawnPosition(loc);
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.setspawn.success", new String[0]));
        return CommandResult.success();
    }
}

