/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import io.github.nucleuspowered.nucleus.util.Tuples;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;

@NoModifiers
@Permissions(prefix="world", suggestedLevel=SuggestedLevel.OWNER)
@RegisterCommand(value={"delete", "del"}, subcommandOf=WorldCommand.class)
@NonnullByDefault
public class DeleteWorldCommand
extends AbstractCommand<CommandSource> {
    @Nullable
    private Tuples.Tri<Instant, UUID, WorldProperties> confirm = null;

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.WORLD_PROPERTIES_ALL};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        WorldProperties properties = (WorldProperties)args.getOne("world").get();
        if (this.confirm != null && this.confirm.getFirst().isAfter(Instant.now()) && this.confirm.getSecond().equals(Util.getUUID(src)) && this.confirm.getThird().getUniqueId().equals(properties.getUniqueId())) {
            try {
                this.completeDeletion(src, properties);
            }
            finally {
                this.confirm = null;
            }
            return CommandResult.success();
        }
        this.confirm = null;
        DeleteWorldCommand.runChecks(properties);
        this.confirm = Tuples.of(Instant.now().plus(30L, ChronoUnit.SECONDS), Util.getUUID(src), properties);
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.delete.warning1", properties.getWorldName()));
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.delete.warning3", properties.getWorldName()));
        return CommandResult.success();
    }

    private void completeDeletion(CommandSource src, WorldProperties properties) throws Exception {
        Supplier<Optional> source;
        Preconditions.checkNotNull(this.confirm);
        String worldName = this.confirm.getThird().getWorldName();
        DeleteWorldCommand.runChecks(this.confirm.getThird());
        ConsoleSource consoleSource = Sponge.getServer().getConsole();
        this.sendMessageTo(src, "command.world.delete.confirmed", new String[]{worldName});
        if (src != consoleSource) {
            this.sendMessageTo((CommandSource)consoleSource, "command.world.delete.confirmed", new String[]{worldName});
        }
        CompletableFuture completableFuture = Sponge.getServer().deleteWorld(properties);
        if (src instanceof Player) {
            UUID uuid = ((Player)src).getUniqueId();
            source = () -> Sponge.getServer().getPlayer(uuid);
        } else {
            source = Optional::empty;
        }
        Task.builder().async().execute(task -> {
            boolean result;
            try {
                result = (Boolean)completableFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                result = false;
                e.printStackTrace();
            }
            if (!result) {
                ((Optional)source.get()).ifPresent(x -> this.sendMessageTo((CommandSource)x, "command.world.delete.complete.error", new String[]{worldName}));
                this.sendMessageTo((CommandSource)consoleSource, "command.world.delete.complete.error", new String[]{worldName});
            } else {
                ((Optional)source.get()).ifPresent(x -> this.sendMessageTo((CommandSource)x, "command.world.delete.complete.success", new String[]{worldName}));
                this.sendMessageTo((CommandSource)consoleSource, "command.world.delete.complete.success", new String[]{worldName});
            }
        }).submit((Object)Nucleus.getNucleus());
    }

    private static void runChecks(WorldProperties properties) throws ReturnMessageException {
        if (Sponge.getServer().getWorld(properties.getUniqueId()).isPresent()) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.delete.loaded", properties.getWorldName()));
        }
    }
}

