/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.vanish.commands;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.vanish.datamodules.VanishUserDataModule;
import io.github.nucleuspowered.nucleus.modules.vanish.services.VanishService;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(supportsOthers=true)
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"vanish", "v"})
@EssentialsEquivalent(value={"vanish", "v"})
public class VanishCommand
extends AbstractCommand<CommandSource> {
    private final String player = "player";
    private final String b = "toggle";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)this.requirePermissionArg(GenericArguments.user((Text)Text.of((String)this.player)), this.permissions.getOthers())), GenericArguments.optional((CommandElement)GenericArguments.onlyOne((CommandElement)GenericArguments.bool((Text)Text.of((String)this.b))))};
    }

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap mspi = Maps.newHashMap();
        mspi.put("see", PermissionInformation.getWithTranslation("permission.vanish.see", SuggestedLevel.ADMIN));
        mspi.put("persist", PermissionInformation.getWithTranslation("permission.vanish.persist", SuggestedLevel.ADMIN));
        mspi.put("onlogin", PermissionInformation.getWithTranslation("permission.vanish.onlogin", SuggestedLevel.NONE));
        return mspi;
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        User ou = this.getUserFromArgs(User.class, src, this.player, args);
        if (ou.getPlayer().isPresent()) {
            return this.onPlayer(src, args, (Player)ou.getPlayer().get());
        }
        if (!this.permissions.testSuffix((Subject)ou, "persist")) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.vanish.noperm", ou.getName()));
        }
        VanishUserDataModule uss = Nucleus.getNucleus().getUserDataManager().getUnchecked(ou).get(VanishUserDataModule.class);
        uss.setVanished(args.getOne(this.b).orElse(!uss.isVanished()));
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.vanish.successuser", ou.getName(), uss.isVanished() ? Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("command.vanish.vanished", new String[0]) : Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("command.vanish.visible", new String[0])));
        return CommandResult.success();
    }

    private CommandResult onPlayer(CommandSource src, CommandContext args, Player playerToVanish) throws Exception {
        if (playerToVanish.get(Keys.GAME_MODE).orElse(GameModes.NOT_SET).equals(GameModes.SPECTATOR)) {
            throw ReturnMessageException.fromKey("command.vanish.fail", new Object[0]);
        }
        boolean toVanish = args.getOne(this.b).orElse(playerToVanish.get(Keys.VANISH).orElse(false) == false);
        if (toVanish) {
            ((VanishService)this.getServiceUnchecked(VanishService.class)).vanishPlayer(playerToVanish);
        } else {
            ((VanishService)this.getServiceUnchecked(VanishService.class)).unvanishPlayer(playerToVanish);
        }
        playerToVanish.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.vanish.success", toVanish ? Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("command.vanish.vanished", new String[0]) : Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("command.vanish.visible", new String[0])));
        if (!(src instanceof Player) || !((Player)src).getUniqueId().equals(playerToVanish.getUniqueId())) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.vanish.successplayer", TextSerializers.FORMATTING_CODE.serialize(Nucleus.getNucleus().getNameUtil().getName((User)playerToVanish)), toVanish ? Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("command.vanish.vanished", new String[0]) : Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("command.vanish.visible", new String[0])));
        }
        return CommandResult.success();
    }
}

