/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.playerinfo.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.api.service.NucleusSeenService;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@APIService(value=NucleusSeenService.class)
@NonnullByDefault
public class SeenHandler
implements NucleusSeenService,
ServiceBase {
    private final Map<String, List<NucleusSeenService.SeenInformationProvider>> moduleInformationProviders = Maps.newTreeMap();
    private final Map<String, List<NucleusSeenService.SeenInformationProvider>> pluginInformationProviders = Maps.newTreeMap();

    @Override
    public void register(@Nonnull Object plugin, @Nonnull NucleusSeenService.SeenInformationProvider seenInformationProvider) throws IllegalArgumentException {
        List<Object> providers;
        Preconditions.checkNotNull((Object)plugin);
        Preconditions.checkNotNull((Object)seenInformationProvider);
        Plugin pl = plugin.getClass().getAnnotation(Plugin.class);
        Preconditions.checkArgument((pl != null ? 1 : 0) != 0, (Object)NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("seen.error.requireplugin", new String[0]));
        String name = pl.name();
        if (this.pluginInformationProviders.containsKey(name)) {
            providers = this.pluginInformationProviders.get(name);
        } else {
            providers = Lists.newArrayList();
            this.pluginInformationProviders.put(name, (List<NucleusSeenService.SeenInformationProvider>)providers);
        }
        providers.add(seenInformationProvider);
    }

    @Override
    public void register(Object plugin, final Predicate<CommandSource> permissionCheck, final BiFunction<CommandSource, User, Collection<Text>> informationGetter) throws IllegalArgumentException {
        this.register(plugin, new NucleusSeenService.SeenInformationProvider(){

            @Override
            public boolean hasPermission(@Nonnull CommandSource source, @Nonnull User user) {
                return permissionCheck.test(source);
            }

            @Override
            public Collection<Text> getInformation(@Nonnull CommandSource source, @Nonnull User user) {
                return (Collection)informationGetter.apply(source, user);
            }
        });
    }

    public void register(Nucleus plugin, String module, NucleusSeenService.SeenInformationProvider seenInformationProvider) throws IllegalArgumentException {
        List<Object> providers;
        Preconditions.checkNotNull((Object)plugin);
        Preconditions.checkNotNull((Object)module);
        Preconditions.checkNotNull((Object)seenInformationProvider);
        Preconditions.checkArgument((boolean)plugin.getClass().getAnnotation(Plugin.class).equals(NucleusPlugin.class.getAnnotation(Plugin.class)));
        if (this.moduleInformationProviders.containsKey(module)) {
            providers = this.moduleInformationProviders.get(module);
        } else {
            providers = Lists.newArrayList();
            this.moduleInformationProviders.put(module, (List<NucleusSeenService.SeenInformationProvider>)providers);
        }
        providers.add(seenInformationProvider);
    }

    public List<Text> buildInformation(CommandSource requester, User user) {
        List<Text> information = this.getModuleText(requester, user);
        information.addAll(this.getText(requester, user));
        return information;
    }

    private List<Text> getModuleText(CommandSource requester, User user) {
        ArrayList information = Lists.newArrayList();
        for (Map.Entry<String, List<NucleusSeenService.SeenInformationProvider>> entry : this.moduleInformationProviders.entrySet()) {
            entry.getValue().stream().filter(sip -> sip.hasPermission(requester, user)).forEach(sip -> {
                Collection<Text> input = sip.getInformation(requester, user);
                if (input != null && !input.isEmpty()) {
                    information.addAll(input);
                }
            });
        }
        return information;
    }

    private List<Text> getText(CommandSource requester, User user) {
        ArrayList information = Lists.newArrayList();
        for (Map.Entry<String, List<NucleusSeenService.SeenInformationProvider>> entry : this.pluginInformationProviders.entrySet()) {
            entry.getValue().stream().filter(sip -> sip.hasPermission(requester, user)).forEach(sip -> {
                Collection<Text> input = sip.getInformation(requester, user);
                if (input != null && !input.isEmpty()) {
                    if (information.isEmpty()) {
                        information.add(Text.EMPTY);
                        information.add(Text.of((String)"-----"));
                        information.add(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("seen.header.plugins", new String[0]));
                        information.add(Text.of((String)"-----"));
                    }
                    information.add(Text.EMPTY);
                    information.add(Text.of((Object[])new Object[]{TextColors.AQUA, (String)entry.getKey() + ":"}));
                    information.addAll(input);
                }
            });
        }
        return information;
    }
}

