/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.playerinfo.commands;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableMap;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.CommandBuilder;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.modules.core.datamodules.CoreUserDataModule;
import io.github.nucleuspowered.nucleus.modules.playerinfo.services.SeenHandler;
import io.github.nucleuspowered.nucleus.modules.teleport.commands.TeleportPositionCommand;
import io.github.nucleuspowered.nucleus.util.TriFunction;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.storage.WorldProperties;

@Permissions
@RunAsync
@RegisterCommand(value={"seen", "seenplayer", "lookup"})
@EssentialsEquivalent(value={"seen"})
@NonnullByDefault
public class SeenCommand
extends AbstractCommand<CommandSource> {
    private static final NumberFormat NUMBER_FORMATTER = new DecimalFormat("0.00");
    private final SeenHandler seenHandler = (SeenHandler)this.getServiceUnchecked(SeenHandler.class);
    private static final String EXTENDED_SUFFIX = "extended";
    public static final String EXTENDED_PERMISSION = "nucleus.seen.extended";
    private static final String IP_PERMISSION = "nucleus.seen.extended.ip";
    private static final String UUID_PERMISSION = "nucleus.seen.extended.uuid";
    private static final String FIRST_PLAYED_PERMISSION = "nucleus.seen.extended.firstplayed";
    private static final String LAST_PLAYED_PERMISSION = "nucleus.seen.extended.lastplayed";
    private static final String SPEED_PERMISSION = "nucleus.seen.extended.speed";
    private static final String WALKING_SPEED_PERMISSION = "nucleus.seen.extended.speed.walking";
    private static final String FLYING_SPEED_PERMISSION = "nucleus.seen.extended.speed.flying";
    private static final String LOCATION_PERMISSION = "nucleus.seen.extended.location";
    private static final String FLYING_PERMISSION = "nucleus.seen.extended.flying";
    private static final String CANFLY_FLYING_PERMISSION = "nucleus.seen.extended.flying.canfly";
    private static final String ISFLYING_FLYING_PERMISSION = "nucleus.seen.extended.flying.isflying";
    private static final String GAMEMODE_PERMISSION = "nucleus.seen.extended.gamemode";
    private final ImmutableMap<String, TriFunction<CommandSource, User, CoreUserDataModule, Text>> entries = ImmutableMap.builder().put((Object)"nucleus.seen.extended.uuid", this::getUUID).put((Object)"nucleus.seen.extended.ip", this::getIP).put((Object)"nucleus.seen.extended.firstplayed", this::getFirstPlayed).put((Object)"nucleus.seen.extended.lastplayed", this::getLastPlayed).put((Object)"nucleus.seen.extended.speed.walking", this::getWalkingSpeed).put((Object)"nucleus.seen.extended.speed.flying", this::getFlyingSpeed).put((Object)"nucleus.seen.extended.location", this::getLocation).put((Object)"nucleus.seen.extended.flying", this::getFlyingSpeed).put((Object)"nucleus.seen.extended.flying.canfly", this::getCanFly).put((Object)"nucleus.seen.extended.flying.isflying", this::getIsFlying).put((Object)"nucleus.seen.extended.gamemode", this::getGameMode).build();

    @Nullable
    private Text getUUID(CommandSource source, User user, CoreUserDataModule userDataModule) {
        return this.getMessageFor(source, "command.seen.uuid", new Object[]{user.getUniqueId()});
    }

    @Nullable
    private Text getIP(CommandSource source, User user, CoreUserDataModule userDataModule) {
        Tuple res = user.getPlayer().map(pl -> Tuple.of((Object)this.getMessageFor(source, "command.seen.ipaddress", new String[]{pl.getConnection().getAddress().getAddress().toString()}), (Object)pl.getConnection().getAddress().getAddress().toString())).orElseGet(() -> userDataModule.getLastIp().map(x -> Tuple.of((Object)this.getMessageFor(source, "command.seen.lastipaddress", new String[]{x}), (Object)x)).orElse(null));
        if (res != null) {
            if (Sponge.getCommandManager().get("nucleus:getfromip").isPresent()) {
                return ((Text)res.getFirst()).toBuilder().onHover((HoverAction)TextActions.showText((Text)this.getMessageFor(source, "command.seen.ipclick"))).onClick((ClickAction)TextActions.runCommand((String)("/nucleus:getfromip " + ((String)res.getSecond()).replaceAll("^/", "")))).build();
            }
            return (Text)res.getFirst();
        }
        return null;
    }

    @Nullable
    private Text getFirstPlayed(CommandSource source, User user, CoreUserDataModule userDataModule) {
        Optional<Instant> i = user.get(Keys.FIRST_DATE_PLAYED);
        if (!i.isPresent()) {
            i = userDataModule.getFirstJoin();
        }
        return i.map(x -> this.getMessageFor(source, "command.seen.firstplayed", new String[]{DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(source.getLocale()).withZone(ZoneId.systemDefault()).format((TemporalAccessor)x)})).orElse(null);
    }

    @Nullable
    private Text getLastPlayed(CommandSource source, User user, CoreUserDataModule userDataModule) {
        if (user.isOnline()) {
            return null;
        }
        return user.get(Keys.LAST_DATE_PLAYED).map(x -> this.getMessageFor(source, "command.seen.lastplayed", new String[]{DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(source.getLocale()).withZone(ZoneId.systemDefault()).format((TemporalAccessor)x)})).orElse(null);
    }

    @Nullable
    private Text getLocation(CommandSource source, User user, CoreUserDataModule userDataModule) {
        if (user.isOnline()) {
            return this.getLocationString("command.seen.currentlocation", (Location<World>)((Player)user.getPlayer().get()).getLocation(), source);
        }
        Optional<WorldProperties> wp = user.getWorldUniqueId().map(x -> Sponge.getServer().getWorldProperties(x).orElse(null));
        if (wp.isPresent()) {
            return this.getLocationString("command.seen.lastlocation", wp.get(), user.getPosition(), source);
        }
        return userDataModule.getLogoutLocation().map(worldLocation -> this.getLocationString("command.seen.lastlocation", (Location<World>)worldLocation, source)).orElse(null);
    }

    @Nullable
    private Text getWalkingSpeed(CommandSource source, User user, CoreUserDataModule userDataModule) {
        return user.get(Keys.WALKING_SPEED).map(x -> this.getMessageFor(source, "command.seen.speed.walk", new String[]{NUMBER_FORMATTER.format(x * 20.0)})).orElse(null);
    }

    @Nullable
    private Text getFlyingSpeed(CommandSource source, User user, CoreUserDataModule userDataModule) {
        return user.get(Keys.FLYING_SPEED).map(x -> this.getMessageFor(source, "command.seen.speed.fly", new String[]{NUMBER_FORMATTER.format(x * 20.0)})).orElse(null);
    }

    @Nullable
    private Text getCanFly(CommandSource source, User user, CoreUserDataModule userDataModule) {
        return this.getMessageFor(source, "command.seen.canfly", new String[]{this.getYesNo(user.get(Keys.CAN_FLY).orElse(false))});
    }

    @Nullable
    private Text getIsFlying(CommandSource source, User user, CoreUserDataModule userDataModule) {
        return this.getMessageFor(source, "command.seen.isflying", new String[]{this.getYesNo(user.get(Keys.IS_FLYING).orElse(false))});
    }

    @Nullable
    private Text getGameMode(CommandSource source, User user, CoreUserDataModule userDataModule) {
        return user.get(Keys.GAME_MODE).map(x -> this.getMessageFor(source, "command.seen.gamemode", new String[]{x.getName()})).orElse(null);
    }

    @Override
    protected Map<String, PermissionInformation> permissionsToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put(EXTENDED_PERMISSION, PermissionInformation.getWithTranslation("permission.seen.extended", SuggestedLevel.NONE));
        m.put(IP_PERMISSION, PermissionInformation.getWithTranslation("permission.seen.extendedperms.ip", SuggestedLevel.ADMIN));
        m.put(UUID_PERMISSION, PermissionInformation.getWithTranslation("permission.seen.extendedperms.uuid", SuggestedLevel.ADMIN));
        m.put(FIRST_PLAYED_PERMISSION, PermissionInformation.getWithTranslation("permission.seen.extendedperms.firstplayed", SuggestedLevel.ADMIN));
        m.put(LAST_PLAYED_PERMISSION, PermissionInformation.getWithTranslation("permission.seen.extendedperms.lastplayed", SuggestedLevel.ADMIN));
        m.put(SPEED_PERMISSION, PermissionInformation.getWithTranslation("permission.seen.extendedperms.speed", SuggestedLevel.ADMIN));
        m.put(FLYING_PERMISSION, PermissionInformation.getWithTranslation("permission.seen.extendedperms.flying", SuggestedLevel.ADMIN));
        m.put(GAMEMODE_PERMISSION, PermissionInformation.getWithTranslation("permission.seen.extendedperms.gamemode", SuggestedLevel.ADMIN));
        m.put(LOCATION_PERMISSION, PermissionInformation.getWithTranslation("permission.seen.extendedperms.location", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{NucleusParameters.ONE_USER_UUID, NucleusParameters.ONE_USER})};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        User user = args.getOne("user uuid").orElseGet(() -> (User)args.getOne("user").get());
        user = user.getPlayer().map(x -> x).orElse(user);
        ModularUserService iqsu = Nucleus.getNucleus().getUserDataManager().getUnchecked(user);
        CoreUserDataModule coreUserDataModule = iqsu.get(CoreUserDataModule.class);
        ArrayList<Text> messages = new ArrayList<Text>();
        MessageProvider messageProvider = Nucleus.getNucleus().getMessageProvider();
        if (user.isOnline()) {
            messages.add(messageProvider.getTextMessageWithFormat("command.seen.iscurrently.online", user.getName()));
            coreUserDataModule.getLastLogin().ifPresent(x -> messages.add(messageProvider.getTextMessageWithFormat("command.seen.loggedon", Util.getTimeToNow(x))));
        } else {
            messages.add(messageProvider.getTextMessageWithFormat("command.seen.iscurrently.offline", user.getName()));
            coreUserDataModule.getLastLogout().ifPresent(x -> messages.add(messageProvider.getTextMessageWithFormat("command.seen.loggedoff", Util.getTimeToNow(x))));
        }
        messages.add(messageProvider.getTextMessageWithFormat("command.seen.displayname", TextSerializers.FORMATTING_CODE.serialize(Nucleus.getNucleus().getNameUtil().getName(user))));
        messages.add(Util.SPACE);
        for (Map.Entry entry : this.entries.entrySet()) {
            Text m;
            if (!src.hasPermission((String)entry.getKey()) || (m = (Text)((TriFunction)entry.getValue()).accept(src, user, coreUserDataModule)) == null) continue;
            messages.add(m);
        }
        messages.addAll(this.seenHandler.buildInformation(src, user));
        PaginationService ps = (PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class);
        ps.builder().contents(messages).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).title(messageProvider.getTextMessageWithFormat("command.seen.title", user.getName())).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private Text getLocationString(String key, Location<World> lw, CommandSource source) {
        return this.getLocationString(key, ((World)lw.getExtent()).getProperties(), lw.getPosition(), source);
    }

    private Text getLocationString(String key, WorldProperties worldProperties, Vector3d position, CommandSource source) {
        Text text = this.getMessageFor(source, key, new Text[]{this.getMessageFor(source, "command.seen.locationtemplate", new String[]{worldProperties.getWorldName(), position.toInt().toString()})});
        if (CommandBuilder.isCommandRegistered(TeleportPositionCommand.class) && Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(TeleportPositionCommand.class).testBase((Subject)source)) {
            Text.Builder building = text.toBuilder().onHover((HoverAction)TextActions.showText((Text)this.getMessageFor(source, "command.seen.teleportposition")));
            Sponge.getServer().getWorld(worldProperties.getUniqueId()).ifPresent(x -> building.onClick((ClickAction)TextActions.executeCallback(cs -> {
                if (cs instanceof Player) {
                    NucleusTeleportHandler.setLocation((Player)cs, (Location<World>)new Location((Extent)x, position));
                }
            })));
            return building.build();
        }
        return text;
    }

    private String getYesNo(@Nullable Boolean bool) {
        if (bool == null) {
            bool = false;
        }
        return Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("standard.yesno." + bool.toString().toLowerCase(), new String[0]);
    }
}

