/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.note.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.note.data.NoteData;
import io.github.nucleuspowered.nucleus.modules.note.services.NoteHandler;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.MOD)
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"note", "addnote"})
public class NoteCommand
extends AbstractCommand<CommandSource> {
    private static final String notifyPermission = "nucleus.note.notify";
    private final NoteHandler noteHandler = (NoteHandler)this.getServiceUnchecked(NoteHandler.class);

    @Override
    public Map<String, PermissionInformation> permissionsToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put(notifyPermission, PermissionInformation.getWithTranslation("permission.note.notify", SuggestedLevel.MOD));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.ONE_USER, NucleusParameters.MESSAGE};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        NoteData noteData;
        User user = (User)args.getOne("user").get();
        String note = (String)args.getOne("message").get();
        UUID noter = Util.consoleFakeUUID;
        if (src instanceof Player) {
            noter = ((Player)src).getUniqueId();
        }
        if (this.noteHandler.addNote(user, noteData = new NoteData(Instant.now(), noter, note))) {
            MutableMessageChannel messageChannel = new PermissionMessageChannel(notifyPermission).asMutable();
            messageChannel.addMember((MessageReceiver)src);
            messageChannel.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.note.success", src.getName(), noteData.getNote(), user.getName()));
            return CommandResult.success();
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.warn.fail", user.getName()));
        return CommandResult.empty();
    }
}

