/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.misc.commands;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.DataScanner;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;

@Permissions
@RegisterCommand(value={"entityinfo"})
@NonnullByDefault
public class EntityInfoCommand
extends AbstractCommand<Player> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().permissionFlag(this.permissions.getPermissionWithSuffix("extended"), new String[]{"e", "-extended"}).buildWith(GenericArguments.none())};
    }

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("extended", PermissionInformation.getWithTranslation("permission.entityinfo.extended", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandResult executeCommand(Player player, CommandContext args, Cause cause) {
        Vector3i playerPos = player.getLocation().getBlockPosition();
        Collection entities = player.getWorld().getEntities().stream().filter(x -> x.getLocation().getBlockPosition().distanceSquared(playerPos) < 121).collect(Collectors.toList());
        BlockRay bl = BlockRay.from((Entity)player).distanceLimit(10.0).stopFilter(BlockRay.continueAfterFilter(x -> {
            Vector3i pt1 = x.getLocation().getBlockPosition();
            Vector3i pt2 = pt1.add(0, 1, 0);
            return entities.stream().allMatch(e -> {
                Vector3i current = e.getLocation().getBlockPosition();
                return !current.equals((Object)pt1) && !current.equals((Object)pt2);
            });
        }, (int)1)).build();
        Optional ob = bl.end();
        if (ob.isPresent()) {
            BlockRayHit brh = (BlockRayHit)ob.get();
            Vector3d location = brh.getLocation().getPosition();
            Vector3d locationOneUp = location.add(0.0f, 1.0f, 0.0f);
            Optional<Entity> entityOptional = entities.stream().filter(e -> {
                Vector3i current = e.getLocation().getBlockPosition();
                return current.equals((Object)location.toInt()) || current.equals((Object)locationOneUp.toInt());
            }).min(Comparator.comparingDouble(x -> x.getLocation().getPosition().distanceSquared(location)));
            if (entityOptional.isPresent()) {
                Entity entity = entityOptional.get();
                EntityType type = entity.getType();
                ArrayList<Text> lt = new ArrayList<Text>();
                lt.add(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.entityinfo.id", type.getId(), Util.getTranslatableIfPresent(type)));
                lt.add(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.entityinfo.uuid", entity.getUniqueId().toString()));
                if (args.hasAny("e") || args.hasAny("extended")) {
                    DataScanner.getInstance().getKeysForHolder((DataHolder)entity).entrySet().stream().filter(x -> x.getValue() != null).filter(x -> {
                        try {
                            return entity.supports((Key)x.getValue());
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }).forEach(x -> {
                        Key k = (Key)x.getValue();
                        if (entity.get(k).isPresent()) {
                            DataScanner.getText((CommandSource)player, "command.entityinfo.key", (String)x.getKey(), entity.get(k).get()).ifPresent(lt::add);
                        }
                    });
                }
                ((PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class)).builder().contents(lt).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).title(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.entityinfo.list.header", String.valueOf(brh.getBlockX()), String.valueOf(brh.getBlockY()), String.valueOf(brh.getBlockZ()))).sendTo((MessageReceiver)player);
                return CommandResult.success();
            }
        }
        player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.entityinfo.none", new String[0]));
        return CommandResult.empty();
    }
}

