/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands.kit;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Kit;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.kit.commands.KitFallbackBase;
import io.github.nucleuspowered.nucleus.modules.kit.commands.kit.KitCommand;
import io.github.nucleuspowered.nucleus.modules.kit.datamodules.KitUserDataModule;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(prefix="kit", suggestedLevel=SuggestedLevel.ADMIN)
@RegisterCommand(value={"resetusage", "reset"}, subcommandOf=KitCommand.class)
@RunAsync
@NonnullByDefault
@NoModifiers
public class KitResetUsageCommand
extends KitFallbackBase<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.ONE_USER, KitFallbackBase.KIT_PARAMETER_NO_PERM_CHECK};
    }

    @Override
    public CommandResult executeCommand(CommandSource player, CommandContext args, Cause cause) throws Exception {
        Kit kitInfo = (Kit)args.getOne("kit").get();
        User u = (User)args.getOne("user").get();
        KitUserDataModule inu = Nucleus.getNucleus().getUserDataManager().getUnchecked(u).get(KitUserDataModule.class);
        if (inu.getLastRedeemedTime(kitInfo.getName()) != null) {
            inu.removeKitLastUsedTime(kitInfo.getName().toLowerCase());
            player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.resetuser.success", u.getName(), kitInfo.getName()));
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.kit.resetuser.empty", u.getName(), kitInfo.getName());
    }
}

