/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands.kit;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Kit;
import io.github.nucleuspowered.nucleus.internal.CommandPermissionHandler;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.kit.commands.KitFallbackBase;
import io.github.nucleuspowered.nucleus.modules.kit.commands.kit.KitCommand;
import io.github.nucleuspowered.nucleus.modules.kit.datamodules.KitUserDataModule;
import io.github.nucleuspowered.nucleus.modules.kit.services.KitHandler;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(prefix="kit", suggestedLevel=SuggestedLevel.USER)
@RegisterCommand(value={"list", "ls"}, subcommandOf=KitCommand.class, rootAliasRegister={"kits"})
@RunAsync
@NoModifiers
@NonnullByDefault
public class KitListCommand
extends KitFallbackBase<CommandSource> {
    private final CommandPermissionHandler kitPermissionHandler = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(KitCommand.class);

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        Set<String> kits = KIT_HANDLER.getKitNames();
        if (kits.isEmpty()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.list.empty", new String[0]));
            return CommandResult.empty();
        }
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class);
        ArrayList kitText = Lists.newArrayList();
        KitUserDataModule user = src instanceof Player ? Nucleus.getNucleus().getUserDataManager().getUnchecked(((Player)src).getUniqueId()).get(KitUserDataModule.class) : null;
        boolean showHidden = this.kitPermissionHandler.testSuffix((Subject)src, "showhidden");
        KIT_HANDLER.getKitNames(showHidden).stream().filter(kit -> this.hasPermission((Subject)src, KitHandler.getPermissionForKit(kit.toLowerCase()))).forEach(kit -> kitText.add(this.createKit(src, user, (String)kit, KIT_HANDLER.getKit((String)kit).get())));
        PaginationList.Builder paginationBuilder = paginationService.builder().contents((Iterable)kitText).title(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.list.kits", new String[0])).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"}));
        paginationBuilder.sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private Text createKit(CommandSource source, @Nullable KitUserDataModule user, String kitName, Kit kitObj) {
        Instant lastRedeem;
        LiteralText.Builder tb = Text.builder((String)kitName);
        if (user != null && (lastRedeem = user.getLastRedeemedTime(kitName)) != null) {
            Instant next;
            if (kitObj.isOneTime() && !this.kitPermissionHandler.testSuffix((Subject)source, "exempt.onetime")) {
                return tb.color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.list.onetime", kitName))).style(new TextStyle[]{TextStyles.STRIKETHROUGH}).build();
            }
            Duration interval = kitObj.getCooldown().orElse(Duration.ZERO);
            if (!interval.isZero() && !this.kitPermissionHandler.testCooldownExempt((Subject)source) && (next = lastRedeem.plus(interval)).isAfter(Instant.now())) {
                String time = Util.getTimeToNow(next);
                return tb.color(TextColors.RED).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.list.interval", kitName, time))).style(new TextStyle[]{TextStyles.STRIKETHROUGH}).build();
            }
        }
        Text.Builder builder = tb.color(TextColors.AQUA).onClick((ClickAction)TextActions.runCommand((String)("/kit \"" + kitName + "\""))).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.list.text", kitName))).style(new TextStyle[]{TextStyles.ITALIC});
        if (kitObj.getCost() > 0.0 && Nucleus.getNucleus().getEconHelper().economyServiceExists() && !this.kitPermissionHandler.testCostExempt((Subject)source)) {
            builder = Text.builder().append(new Text[]{builder.build()}).append(new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kit.list.cost", Nucleus.getNucleus().getEconHelper().getCurrencySymbol(kitObj.getCost()))});
        }
        return builder.build();
    }
}

