/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands.kit;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.nucleusdata.Kit;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.Since;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.modules.kit.commands.KitFallbackBase;
import io.github.nucleuspowered.nucleus.modules.kit.commands.kit.KitCommand;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@NoModifiers
@Permissions(prefix="kit")
@RunAsync
@RegisterCommand(value={"info"}, subcommandOf=KitCommand.class)
@Since(spongeApiVersion="7.0", minecraftVersion="1.12.1", nucleusVersion="1.2")
public class KitInfoCommand
extends KitFallbackBase<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{KitFallbackBase.KIT_PARAMETER_NO_PERM_CHECK};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        Kit kit = (Kit)args.getOne("kit").get();
        MessageProvider mp = Nucleus.getNucleus().getMessageProvider();
        Util.getPaginationBuilder(src).title(mp.getTextMessageWithFormat("command.kit.info.title", kit.getName())).contents(new Text[]{this.addViewHover(mp, kit), this.addCommandHover(mp, kit), mp.getTextMessageWithFormat("command.kit.info.sep", new String[0]), mp.getTextMessageWithFormat("command.kit.info.firstjoin", this.yesno(mp, kit.isFirstJoinKit())), mp.getTextMessageWithFormat("command.kit.info.cost", String.valueOf(kit.getCost())), mp.getTextMessageWithFormat("command.kit.info.cooldown", kit.getCooldown().map(x -> Util.getTimeStringFromSeconds(x.getSeconds())).orElse(mp.getMessageWithFormat("standard.nocooldown", new String[0]))), mp.getTextMessageWithFormat("command.kit.info.onetime", this.yesno(mp, kit.isOneTime())), mp.getTextMessageWithFormat("command.kit.info.autoredeem", this.yesno(mp, kit.isAutoRedeem())), mp.getTextMessageWithFormat("command.kit.info.hidden", this.yesno(mp, kit.isHiddenFromList())), mp.getTextMessageWithFormat("command.kit.info.displayredeem", this.yesno(mp, kit.isAutoRedeem())), mp.getTextMessageWithFormat("command.kit.info.ignoresperm", this.yesno(mp, kit.ignoresPermission()))}).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private Text addViewHover(MessageProvider mp, Kit kit) {
        return mp.getTextMessageWithFormat("command.kit.info.itemcount", String.valueOf(kit.getStacks().size())).toBuilder().onHover((HoverAction)TextActions.showText((Text)mp.getTextMessageWithFormat("command.kit.info.hover.itemcount", kit.getName()))).onClick((ClickAction)TextActions.runCommand((String)("/nucleus:kit view " + kit.getName()))).build();
    }

    private Text addCommandHover(MessageProvider mp, Kit kit) {
        return mp.getTextMessageWithFormat("command.kit.info.commandcount", String.valueOf(kit.getCommands().size())).toBuilder().onHover((HoverAction)TextActions.showText((Text)mp.getTextMessageWithFormat("command.kit.info.hover.commandcount", kit.getName()))).onClick((ClickAction)TextActions.runCommand((String)("/nucleus:kit command " + kit.getName()))).build();
    }

    private String yesno(MessageProvider mp, boolean yesno) {
        return mp.getMessageWithFormat("standard.yesno." + yesno, new String[0]);
    }
}

