/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.info.services;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.internal.TextFileController;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.asset.AssetManager;

public class InfoHandler
implements Reloadable,
ServiceBase {
    private final Map<String, TextFileController> infoFiles = Maps.newHashMap();
    private final Nucleus plugin = Nucleus.getNucleus();
    private final Pattern validFile = Pattern.compile("[a-zA-Z0-9_.\\-]+\\.txt", 2);

    public Set<String> getInfoSections() {
        return ImmutableSet.copyOf(this.infoFiles.keySet());
    }

    public Optional<TextFileController> getSection(String name) {
        Optional<String> os = this.infoFiles.keySet().stream().filter(name::equalsIgnoreCase).findFirst();
        return os.map(this.infoFiles::get);
    }

    @Override
    public void onReload() throws Exception {
        List<Path> files;
        Path infoDir = Nucleus.getNucleus().getConfigDirPath().resolve("info");
        if (!Files.exists(infoDir, new LinkOption[0])) {
            Files.createDirectories(infoDir, new FileAttribute[0]);
            AssetManager am = Sponge.getAssetManager();
            ((Asset)am.getAsset((Object)Nucleus.getNucleus(), "info.txt").get()).copyToFile(infoDir.resolve("info.txt"));
            ((Asset)am.getAsset((Object)Nucleus.getNucleus(), "colors.txt").get()).copyToFile(infoDir.resolve("colors.txt"));
            ((Asset)am.getAsset((Object)Nucleus.getNucleus(), "links.txt").get()).copyToFile(infoDir.resolve("links.txt"));
        } else if (!Files.isDirectory(infoDir, new LinkOption[0])) {
            throw new IllegalStateException("The file " + infoDir.toAbsolutePath().toString() + " should be a directory.");
        }
        try (Stream<Path> sp = Files.list(infoDir);){
            files = sp.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(x -> this.validFile.matcher(x.getFileName().toString()).matches()).collect(Collectors.toList());
        }
        HashMap mst = Maps.newHashMap();
        files.forEach(x -> {
            try {
                String name = x.getFileName().toString();
                name = name.substring(0, name.length() - 4);
                if (mst.keySet().stream().anyMatch(name::equalsIgnoreCase)) {
                    Nucleus.getNucleus().getLogger().warn(NucleusPlugin.getNucleus().getMessageProvider().getMessageWithFormat("info.load.duplicate", x.getFileName().toString()));
                    return;
                }
                mst.put(name, new TextFileController((Path)x, true));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.infoFiles.clear();
        this.infoFiles.putAll(mst);
    }
}

