/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.runnables;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.interfaces.TaskBase;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfigAdapter;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class CoreTask
implements TaskBase,
Reloadable {
    private boolean printSave = false;

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public Duration interval() {
        return Duration.of(5L, ChronoUnit.MINUTES);
    }

    @Override
    public void accept(Task task) {
        Nucleus plugin = Nucleus.getNucleus();
        plugin.getUserDataManager().removeOfflinePlayers();
        if (this.printSave || Nucleus.getNucleus().isDebugMode()) {
            plugin.getLogger().info(plugin.getMessageProvider().getMessageWithFormat("core.savetask.starting", new String[0]));
        }
        plugin.saveData();
        if (this.printSave || Nucleus.getNucleus().isDebugMode()) {
            plugin.getLogger().info(plugin.getMessageProvider().getMessageWithFormat("core.savetask.complete", new String[0]));
        }
    }

    @Override
    public void onReload() {
        this.printSave = Nucleus.getNucleus().getConfigValue("core", CoreConfigAdapter.class, CoreConfig::isPrintOnAutosave).orElse(false);
    }
}

