/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands.itemalias;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.ItemAliasArgument;
import io.github.nucleuspowered.nucleus.configurate.datatypes.ItemDataNode;
import io.github.nucleuspowered.nucleus.dataservices.ItemDataService;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.modules.core.commands.itemalias.ItemAliasCommand;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RunAsync
@NoModifiers
@Permissions(prefix="nucleus.itemalias")
@RegisterCommand(value={"set"}, subcommandOf=ItemAliasCommand.class)
@NonnullByDefault
public class SetItemAliasCommand
extends AbstractCommand<CommandSource> {
    private final ItemDataService itemDataService = Nucleus.getNucleus().getItemDataService();
    private final String item = "item";
    private final String alias = "alias";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)new ItemAliasArgument((Text)Text.of((String)this.item))), GenericArguments.string((Text)Text.of((String)this.alias))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        String a = ((String)args.getOne(this.alias).get()).toLowerCase();
        if (this.itemDataService.getIdFromAlias(a).isPresent()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.setitemalias.inuse", a));
            return CommandResult.empty();
        }
        if (!ItemDataNode.ALIAS_PATTERN.matcher(a).matches()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.setitemalias.notvalid", a));
            return CommandResult.empty();
        }
        CatalogType type = this.getCatalogTypeFromHandOrArgs(src, this.item, args);
        String id = type.getId().toLowerCase();
        ItemDataNode idn = this.itemDataService.getDataForItem(id);
        idn.addAlias(a);
        this.itemDataService.setDataForItem(id, idn);
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.setitemalias.success", a, id));
        return CommandResult.success();
    }
}

