/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoCommandPrefix;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.ModuleContainer;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RunAsync
@Permissions
@NoModifiers
@RegisterCommand(value={"nucleus"})
@NoCommandPrefix
@NonnullByDefault
public class NucleusCommand
extends AbstractCommand<CommandSource> {
    private final Text version = Text.of((Object[])new Object[]{TextColors.GREEN, "Nucleus version 1.9.2-S7.1 (built from commit 4ee67592)"});
    @Nullable
    private Text modules = null;

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        if (this.modules == null) {
            LiteralText.Builder tb = Text.builder((String)"Modules: ").color(TextColors.GREEN);
            boolean addComma = false;
            Set<String> enabled = Nucleus.getNucleus().getModuleContainer().getModules();
            for (String module : Nucleus.getNucleus().getModuleContainer().getModules(ModuleContainer.ModuleStatusTristate.ALL)) {
                if (addComma) {
                    tb.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, ", "})});
                }
                tb.append(new Text[]{Text.of((Object[])new Object[]{enabled.contains(module) ? TextColors.GREEN : TextColors.RED, module})});
                addComma = true;
            }
            this.modules = tb.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "."})}).build();
        }
        src.sendMessage(this.version);
        src.sendMessage(this.modules);
        return CommandResult.success();
    }
}

