/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.connection.config;

import java.util.Optional;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

@ConfigSerializable
public class ConnectionConfig {
    @Setting(value="reserved-slots", comment="config.connection.reservedslots")
    private int reservedSlots = -1;
    @Setting(value="whitelist-message", comment="config.connection.whitelistmessage")
    private String whitelistMessage = "";
    @Setting(value="server-full-message", comment="config.connection.serverfullmessage")
    private String serverFullMessage = "";

    public int getReservedSlots() {
        return this.reservedSlots;
    }

    public Optional<Text> getWhitelistMessage() {
        return this.getMessageFrom(this.whitelistMessage);
    }

    public Optional<Text> getServerFullMessage() {
        return this.getMessageFrom(this.serverFullMessage);
    }

    private Optional<Text> getMessageFrom(String text) {
        if (text == null || text.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(TextSerializers.FORMATTING_CODE.deserializeUnchecked(text));
    }
}

