/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.chat.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.EventContexts;
import io.github.nucleuspowered.nucleus.api.chat.NucleusChatChannel;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.text.TextParsingUtils;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatConfig;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.chat.listeners.ChatListener;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.serializer.TextSerializers;

@RegisterCommand(value={"me", "action"})
@Permissions(suggestedLevel=SuggestedLevel.USER)
@EssentialsEquivalent(value={"me", "action", "describe"})
public class MeCommand
extends AbstractCommand<CommandSource>
implements Reloadable {
    private ChatConfig config = null;
    private final MeChannel channel = new MeChannel();

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.MESSAGE};
    }

    @Override
    public CommandResult executeCommand(@Nonnull CommandSource src, CommandContext args, Cause cause) throws Exception {
        String message = ChatListener.stripPermissionless((Subject)src, (String)args.getOne("message").get());
        Text header = this.config.getMePrefix().getForCommandSource(src);
        Nucleus.getNucleus().getTextParsingUtils();
        TextParsingUtils.StyleTuple t = TextParsingUtils.getLastColourAndStyle((TextRepresentable)header, null);
        Text originalMessage = TextSerializers.FORMATTING_CODE.deserialize(message);
        MessageEvent.MessageFormatter formatter = new MessageEvent.MessageFormatter(Text.builder().color(t.colour).style(new TextStyle[]{t.style}).append(new Text[]{TextSerializers.FORMATTING_CODE.deserialize(message)}).toText());
        formatter.setHeader((TextRepresentable)header);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContexts.SHOULD_FORMAT_CHANNEL, (Object)false);
            if (frame.getCurrentCause().root() != src) {
                frame.pushCause((Object)src);
            }
            MessageChannelEvent.Chat event = SpongeEventFactory.createMessageChannelEventChat((Cause)frame.getCurrentCause(), (MessageChannel)this.channel, Optional.of(this.channel), (MessageEvent.MessageFormatter)formatter, (Text)originalMessage, (boolean)false);
            if (Sponge.getEventManager().post((Event)event)) {
                throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.me.cancel", new String[0]));
            }
            ((MessageChannel)event.getChannel().orElse(this.channel)).send((Object)src, Util.applyChatTemplate(event.getFormatter()), ChatTypes.CHAT);
        }
        return CommandResult.success();
    }

    @Override
    public void onReload() {
        this.config = (ChatConfig)Nucleus.getNucleus().getInternalServiceManager().getServiceUnchecked(ChatConfigAdapter.class).getNodeOrDefault();
    }

    public class MeChannel
    implements NucleusChatChannel.ActionMessage {
        @Nonnull
        public Collection<MessageReceiver> getMembers() {
            return MessageChannel.TO_ALL.getMembers();
        }

        @Override
        public boolean removePrefix() {
            return false;
        }
    }
}

