/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.admin.commands.exp;

import io.github.nucleuspowered.nucleus.argumentparsers.ExperienceLevelArgument;
import io.github.nucleuspowered.nucleus.argumentparsers.PositiveIntegerArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.modules.admin.commands.ExperienceCommand;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NoModifiers
@Permissions(prefix="exp")
@RegisterCommand(value={"give"}, subcommandOf=ExperienceCommand.class)
@NonnullByDefault
public class GiveExperience
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_PLAYER, GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.onlyOne((CommandElement)new ExperienceLevelArgument((Text)Text.of((String)"level"))), GenericArguments.onlyOne((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)"experience")))})};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        int extra;
        Player pl = this.getUserFromArgs(Player.class, src, "player", args);
        if (!ExperienceCommand.checkGameMode(pl, src)) {
            return CommandResult.empty();
        }
        if (args.hasAny("level")) {
            int lvl = pl.get(Keys.EXPERIENCE_LEVEL).orElse(0) + (Integer)args.getOne("level").get();
            extra = pl.get(Keys.EXPERIENCE_SINCE_LEVEL).orElse(0);
            pl.tryOffer(Keys.EXPERIENCE_LEVEL, (Object)lvl);
        } else {
            extra = (Integer)args.getOne("experience").get();
        }
        int exp = (Integer)pl.get(Keys.TOTAL_EXPERIENCE).get();
        return ExperienceCommand.tellUserAboutExperience(src, pl, pl.offer(Keys.TOTAL_EXPERIENCE, (Object)(exp += extra)).isSuccessful());
    }
}

