/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.admin.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import java.util.Collection;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(supportsSelectors=true)
@RegisterCommand(value={"kill"})
@EssentialsEquivalent(value={"kill", "remove", "butcher", "killall", "mobkill"}, isExact=false, notes="Nucleus supports killing entities using the Minecraft selectors.")
@NonnullByDefault
public class KillCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.MANY_ENTITY};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        Collection entities = args.getAll("subject");
        int entityKillCount = 0;
        int playerKillCount = 0;
        for (Entity x : entities) {
            DataTransactionResult dtr = x.offer(Keys.HEALTH, (Object)0.0);
            if (!dtr.isSuccessful() && !(x instanceof Living)) {
                x.remove();
            }
            ++entityKillCount;
            if (!(x instanceof Player)) continue;
            ++playerKillCount;
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kill.killed", Nucleus.getNucleus().getNameUtil().getSerialisedName((User)((Player)x))));
            ((Player)x).sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kill.killedby", src.getName()));
        }
        if (entityKillCount > playerKillCount) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kill.overall", String.valueOf(entityKillCount), String.valueOf(playerKillCount)));
        }
        return CommandResult.success();
    }
}

