/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.api.events;

import io.github.nucleuspowered.nucleus.api.NucleusAPI;
import io.github.nucleuspowered.nucleus.api.annotations.MightOccurAsync;
import io.github.nucleuspowered.nucleus.api.exceptions.NucleusException;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import java.util.Collection;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.text.Text;

@MightOccurAsync
public interface NucleusTextTemplateEvent
extends Event,
Cancellable {
    public NucleusTextTemplate getMessage();

    public NucleusTextTemplate getOriginalMessage();

    public void setMessage(NucleusTextTemplate var1);

    default public void setMessage(String message) {
        try {
            this.setMessage(NucleusAPI.getMessageTokenService().createFromString(message));
        }
        catch (NucleusException e) {
            throw new IllegalArgumentException("Could not create the NucleusTextTemplate", (Throwable)((Object)e));
        }
    }

    public Collection<CommandSource> getOriginalRecipients();

    public Collection<CommandSource> getRecipients();

    public void setRecipients(Collection<? extends CommandSource> var1);

    default public boolean containsTokens() {
        return this.getMessage().containsTokens();
    }

    default public Text getMessageFor(CommandSource source) {
        return this.getMessage().getForCommandSource(source);
    }

    public static interface Broadcast
    extends NucleusTextTemplateEvent {
        default public void sendToAll() {
            this.setRecipients(this.getOriginalRecipients());
        }
    }
}

