/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.refinedstorage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.util.Action;
import dan200.computercraft.api.lua.LuaException;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.squiddev.plethora.api.method.ArgumentHelper;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.ITransferMethod;
import org.squiddev.plethora.api.method.MarkerInterfaces;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.integration.vanilla.NullableItemStack;
import org.squiddev.plethora.integration.vanilla.method.MethodsInventoryTransfer;

public final class MethodExportItem {
    private MethodExportItem() {
    }

    @PlethoraMethod(modId="refinedstorage", doc="-- Export this item from the RS network to an inventory. Returns the amount transferred.")
    @MarkerInterfaces(value={ITransferMethod.class})
    public static int export(IContext<NullableItemStack> context, @FromContext INetworkNode node, String toName, @Optional(defInt=0x7FFFFFFF) int limit, @Optional int toSlot) throws LuaException {
        ItemStack remainder;
        if (limit <= 0) {
            throw new LuaException("Limit must be > 0");
        }
        Object location = context.getTransferLocation(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IItemHandler to = MethodsInventoryTransfer.extractHandler(location);
        if (to == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        if (toSlot != -1) {
            ArgumentHelper.assertBetween(toSlot, 1, to.getSlots(), "To slot out of range (%s)");
        }
        NullableItemStack toExtract = (NullableItemStack)context.getTarget();
        INetwork network = node.getNetwork();
        if (network == null) {
            throw new LuaException("Cannot find network");
        }
        int extractLimit = Math.min(limit, toExtract.getFilledStack().func_77976_d());
        ItemStack toInsert = network.extractItem(toExtract.getFilledStack(), extractLimit, Action.PERFORM);
        if (toInsert == null || toInsert.func_190926_b()) {
            return 0;
        }
        ItemStack itemStack = remainder = toSlot <= 0 ? ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)toInsert, (boolean)false) : to.insertItem(toSlot - 1, toInsert, false);
        if (!remainder.func_190926_b()) {
            network.insertItem(remainder, remainder.func_190916_E(), Action.PERFORM);
        }
        return toInsert.func_190916_E() - remainder.func_190916_E();
    }
}

