/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.refinedstorage;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.ItemStackContextMetaProvider;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.LuaList;

@Injects(value="refinedstorage")
public final class MetaItemPattern
extends ItemStackContextMetaProvider<ItemPattern> {
    public MetaItemPattern() {
        super("pattern", ItemPattern.class);
    }

    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull IPartialContext<ItemStack> context, @Nonnull ItemPattern item) {
        ItemStack stack = context.getTarget();
        IWorldLocation position = context.getContext("origin", IWorldLocation.class);
        if (position != null) {
            CraftingPattern pattern = ItemPattern.getPatternFromCache((World)position.getWorld(), (ItemStack)stack);
            return context.makePartialChild(pattern).getMeta();
        }
        HashMap<String, Object> out = new HashMap<String, Object>();
        out.put("id", "normal");
        out.put("outputs", MetaItemPattern.getMetaItems(context, stack, ItemPattern::getOutputSlot));
        out.put("fluidOutputs", MetaItemPattern.getMetaItems(context, stack, ItemPattern::getFluidOutputSlot));
        out.put("inputs", MetaItemPattern.getMetaItems(context, stack, ItemPattern::getInputSlot));
        out.put("fluidInputs", MetaItemPattern.getMetaItems(context, stack, ItemPattern::getFluidInputSlot));
        out.put("oredict", ItemPattern.isOredict((ItemStack)stack));
        out.put("processing", ItemPattern.isProcessing((ItemStack)stack));
        return out;
    }

    private static <T> Map<Integer, TypedMeta<T, ?>> getMetaItems(IPartialContext<?> context, ItemStack stack, IntStackFunction<T> func) {
        LuaList out = new LuaList(9);
        for (int i = 0; i < 9; ++i) {
            T result = func.apply(stack, i);
            if (result == null) continue;
            out.add(context.makePartialChild(result).getMeta());
        }
        return out.asMap();
    }

    @Override
    @Nonnull
    public ItemStack getExample() {
        return MetaItemPattern.getExampleStack();
    }

    @Nonnull
    public static ItemStack getExampleStack() {
        ItemStack stack = new ItemStack((Item)RSItems.PATTERN);
        ItemPattern.setInputSlot((ItemStack)stack, (int)0, (ItemStack)new ItemStack(Blocks.field_150344_f));
        ItemPattern.setInputSlot((ItemStack)stack, (int)1, (ItemStack)new ItemStack(Blocks.field_150344_f));
        ItemPattern.setOutputSlot((ItemStack)stack, (int)0, (ItemStack)new ItemStack(Items.field_151055_y, 4));
        return stack;
    }

    @FunctionalInterface
    public static interface IntStackFunction<T> {
        public T apply(ItemStack var1, int var2);
    }
}

