/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.ic2;

import dan200.computercraft.api.lua.LuaException;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.TypedLuaObject;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.reference.DynamicReference;

public final class MethodsReactor {
    private MethodsReactor() {
    }

    @PlethoraMethod(modId="ic2", doc="-- Get a reference to the reactor's core")
    public static TypedLuaObject<IReactor> getReactorCore(IContext<IReactorChamber> context) {
        IReactor core = ((IReactorChamber)context.getTarget()).getReactorInstance();
        return context.makeChild(core, new ReactorReference(core)).getObject();
    }

    private static class ReactorReference
    implements DynamicReference<IReactor> {
        private final IReactor core;
        private final TileEntity expected;

        ReactorReference(IReactor core) {
            this.core = core;
            this.expected = core.getCoreTe();
        }

        @Override
        @Nonnull
        public IReactor get() throws LuaException {
            if (this.core.getCoreTe() != this.expected) {
                throw new LuaException("The reactor has changed");
            }
            return this.core;
        }

        @Override
        @Nonnull
        public IReactor safeGet() {
            return this.core;
        }
    }
}

