/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.neural;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.EntityWorldLocation;
import org.squiddev.plethora.api.IPeripheralHandler;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.method.CostHelpers;
import org.squiddev.plethora.api.method.IContextBuilder;
import org.squiddev.plethora.api.method.IContextFactory;
import org.squiddev.plethora.api.method.ICostHandler;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.module.BasicModuleContainer;
import org.squiddev.plethora.api.module.IModuleAccess;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.module.IModuleHandler;
import org.squiddev.plethora.api.reference.ConstantReference;
import org.squiddev.plethora.api.reference.IReference;
import org.squiddev.plethora.api.reference.Reference;
import org.squiddev.plethora.core.AttachableWrapperPeripheral;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.Context;
import org.squiddev.plethora.core.ContextFactory;
import org.squiddev.plethora.core.MethodRegistry;
import org.squiddev.plethora.core.UnbakedContext;
import org.squiddev.plethora.gameplay.modules.ModulePeripheral;
import org.squiddev.plethora.gameplay.neural.NeuralComputer;
import org.squiddev.plethora.gameplay.registry.Registration;
import org.squiddev.plethora.utils.LoadedCache;
import org.squiddev.plethora.utils.TinySlot;

public final class NeuralHelpers {
    public static final EntityEquipmentSlot ARMOR_SLOT = EntityEquipmentSlot.HEAD;
    public static final int MODULE_SIZE = 5;
    public static final int PERIPHERAL_SIZE = 5;
    public static final int INV_SIZE = 10;
    public static final int BACK = 2;

    private NeuralHelpers() {
        throw new IllegalStateException("Cannot instantiate");
    }

    @Nullable
    public static TinySlot getSlot(EntityLivingBase entity) {
        TinySlot slot;
        ItemStack stack = entity.func_184582_a(ARMOR_SLOT);
        if (!stack.func_190926_b() && stack.func_77973_b() == Registration.itemNeuralInterface) {
            return entity instanceof EntityPlayer ? new TinySlot.InventorySlot(stack, (IInventory)((EntityPlayer)entity).field_71071_by) : new TinySlot(stack);
        }
        if (LoadedCache.hasBaubles() && entity instanceof EntityPlayer && (slot = NeuralHelpers.getBauble((EntityPlayer)entity)) != null) {
            return slot;
        }
        return null;
    }

    @Nonnull
    @Optional.Method(modid="baubles")
    public static BaubleType getBaubleType() {
        return BaubleType.HEAD;
    }

    @Nullable
    @Optional.Method(modid="baubles")
    public static TinySlot getBauble(@Nonnull EntityPlayer player) {
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int slot : NeuralHelpers.getBaubleType().getValidSlots()) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.func_77973_b() != Registration.itemNeuralInterface) continue;
            return new TinySlot.BaublesSlot(stack, handler, slot);
        }
        return null;
    }

    @Nonnull
    public static ItemStack getStack(EntityLivingBase entity) {
        TinySlot slot = NeuralHelpers.getSlot(entity);
        return slot == null ? ItemStack.field_190927_a : slot.getStack();
    }

    public static IPeripheral buildPeripheral(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        IPeripheral peripheral = (IPeripheral)stack.getCapability(Constants.PERIPHERAL_CAPABILITY, null);
        if (peripheral != null) {
            return peripheral;
        }
        IPeripheralHandler pHandler = (IPeripheralHandler)stack.getCapability(Constants.PERIPHERAL_HANDLER_CAPABILITY, null);
        if (pHandler != null) {
            return pHandler.getPeripheral();
        }
        return null;
    }

    public static IPeripheral buildModules(final NeuralComputer computer, final NonNullList<ItemStack> inventory, Entity owner) {
        final NonNullList stacks = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        HashSet<ResourceLocation> modules = new HashSet<ResourceLocation>();
        HashSet<IModuleHandler> moduleHandlers = new HashSet<IModuleHandler>();
        final int moduleHash = computer.getModuleHash();
        for (int i = 0; i < 5; ++i) {
            ResourceLocation module;
            ItemStack stack = (ItemStack)inventory.get(5 + i);
            if (stack.func_190926_b()) continue;
            stack = stack.func_77946_l();
            stacks.set(i, (Object)stack);
            IModuleHandler moduleHandler = (IModuleHandler)stack.getCapability(Constants.MODULE_HANDLER_CAPABILITY, null);
            if (moduleHandler == null || ConfigCore.Blacklist.blacklistModules.contains((module = moduleHandler.getModule()).toString())) continue;
            modules.add(module);
            moduleHandlers.add(moduleHandler);
        }
        if (modules.isEmpty()) {
            return null;
        }
        final BasicModuleContainer container = new BasicModuleContainer(modules);
        HashMap<ResourceLocation, NeuralAccess> accessMap = new HashMap<ResourceLocation, NeuralAccess>();
        ICostHandler cost = CostHelpers.getCostHandler((ICapabilityProvider)owner);
        ConstantReference<IModuleContainer> containerRef = new ConstantReference<IModuleContainer>(){

            @Override
            @Nonnull
            public IModuleContainer get() throws LuaException {
                for (int i = 0; i < 5; ++i) {
                    ItemStack oldStack = (ItemStack)stacks.get(i);
                    ItemStack newStack = (ItemStack)inventory.get(5 + i);
                    if (oldStack.func_190926_b() || ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)newStack)) continue;
                    IModuleHandler moduleHandler = (IModuleHandler)oldStack.getCapability(Constants.MODULE_HANDLER_CAPABILITY, null);
                    throw new LuaException("The " + moduleHandler.getModule() + " module has been removed");
                }
                return container;
            }

            @Override
            @Nonnull
            public IModuleContainer safeGet() throws LuaException {
                if (moduleHash != computer.getModuleHash()) {
                    throw new LuaException("A module has changed");
                }
                return container;
            }
        };
        IContextFactory builder = ((ContextFactory)((ContextFactory)((ContextFactory)ContextFactory.of(container, containerRef).withCostHandler(cost)).withModules((IModuleContainer)container, containerRef)).addContext("origin", new EntityWorldLocation(owner))).addContext("origin", owner, (IReference)Reference.entity(owner));
        for (IModuleHandler handler : moduleHandlers) {
            ResourceLocation module = handler.getModule();
            NeuralAccess access = (NeuralAccess)accessMap.get(module);
            if (access == null) {
                access = new NeuralAccess(owner, computer, handler, container);
                accessMap.put(module, access);
            }
            handler.getAdditionalContext(access, (IContextBuilder)((Object)builder));
        }
        Pair<List<IMethod<?>>, List<UnbakedContext<?>>> paired = MethodRegistry.instance.getMethodsPaired((Context<?>)((ContextFactory)builder).getBaked());
        if (((List)paired.getLeft()).isEmpty()) {
            return null;
        }
        ModulePeripheral peripheral = new ModulePeripheral("neuralInterface", owner, paired, computer.getExecutor(), ((ContextFactory)builder).getAttachments(), moduleHash);
        for (NeuralAccess access : accessMap.values()) {
            access.wrapper = peripheral;
        }
        return peripheral;
    }

    private static final class NeuralAccess
    implements IModuleAccess {
        private AttachableWrapperPeripheral wrapper;
        private final Entity owner;
        private final NeuralComputer computer;
        private final ResourceLocation module;
        private final IModuleContainer container;
        private final IWorldLocation location;

        private NeuralAccess(Entity owner, NeuralComputer computer, IModuleHandler module, IModuleContainer container) {
            this.owner = owner;
            this.computer = computer;
            this.module = module.getModule();
            this.container = container;
            this.location = new EntityWorldLocation(owner);
        }

        @Override
        @Nonnull
        public Object getOwner() {
            return this.owner;
        }

        @Override
        @Nonnull
        public IWorldLocation getLocation() {
            return this.location;
        }

        @Override
        @Nonnull
        public IModuleContainer getContainer() {
            return this.container;
        }

        @Override
        @Nonnull
        public NBTTagCompound getData() {
            return this.computer.getModuleData(this.module);
        }

        @Override
        public void markDataDirty() {
            this.computer.markModuleDataDirty();
        }

        @Override
        public void queueEvent(@Nonnull String event, Object ... args) {
            if (this.wrapper != null) {
                this.wrapper.queueEvent(event, args);
            }
        }
    }
}

