/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object2d;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ColourableObject;
import org.squiddev.plethora.gameplay.modules.glasses.objects.Scalable;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object2d.Positionable2D;
import org.squiddev.plethora.utils.ByteBufUtils;
import org.squiddev.plethora.utils.Vec2d;

public class Dot
extends ColourableObject
implements Positionable2D,
Scalable {
    private Vec2d position = Vec2d.ZERO;
    private float scale = 1.0f;

    public Dot(int id, int parent) {
        super(id, parent, (byte)2);
    }

    @Override
    @Nonnull
    public Vec2d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@Nonnull Vec2d position) {
        if (!Objects.equal((Object)this.position, (Object)position)) {
            this.position = position;
            this.setDirty();
        }
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        if (this.scale != scale) {
            this.scale = scale;
            this.setDirty();
        }
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        super.writeInitial(buf);
        ByteBufUtils.writeVec2d(buf, this.position);
        buf.writeFloat(this.scale);
    }

    @Override
    public void readInitial(ByteBuf buf) {
        super.readInitial(buf);
        this.position = ByteBufUtils.readVec2d(buf);
        this.scale = buf.readFloat();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        Dot.setupFlat();
        float x = (float)this.position.x;
        float y = (float)this.position.y;
        float delta = this.scale / 2.0f;
        int red = this.getRed();
        int green = this.getGreen();
        int blue = this.getBlue();
        int alpha = this.getAlpha();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)(x - delta), (double)(y - delta), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b((double)(x - delta), (double)(y + delta), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b((double)(x + delta), (double)(y + delta), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b((double)(x - delta), (double)(y - delta), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b((double)(x + delta), (double)(y + delta), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b((double)(x + delta), (double)(y - delta), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }
}

